/* Copyright 2021-2022 Ethan Halsall. This file is part of wasm-audio-decoders. https://github.com/eshaz/wasm-audio-decoders */
var t,s;t=this,s=function(t,s){function e(){const t=Uint8Array,s=Float32Array;e.t||Object.defineProperties(e,{t:{value:new WeakMap},o:{value(t,s){e.t.set(t,Promise.resolve(s))}},u:{value(t,s){let i=e.t.get(t);return i||(s?i=WebAssembly.compile(e.U(s)):(s=t.p,i=e.M(s).then((t=>WebAssembly.compile(t)))),e.t.set(t,i)),i}},T:{value(t,e){let i=new s(e),r=0,n=0;for(;r<t.length;)i.set(t[r],n),n+=t[r++].length;return i}},$:{value:(t,s,e,i,r)=>({A:t,channelData:s,samplesDecoded:e,sampleRate:i,bitDepth:r})},O:{value(t,s,i,r,n,h){let o,a,l=[];for(o=0;o<i;o++){const t=[];for(a=0;a<s.length;)t.push(s[a++][o]||[]);l.push(e.T(t,r))}return e.$(t,l,r,n,h)}},C:{value:(()=>{let t,s,e,i=new Int32Array(256);for(t=0;t<256;t++){for(e=t<<24,s=8;s>0;--s)e=2147483648&e?e<<1^79764919:e<<1;i[t]=e}return i})()},U:{value(s){let i,r,n,h=new t(s.length),o=parseInt(s.substring(11,13),16),a=256-o,l=!1,c=0,u=21,d=4294967295;for(;u<s.length;)r=s.charCodeAt(u++),61!==r||l?(l&&(l=!1,r-=64),h[c]=r<o&&r>0?r+a:r-o,d=d<<8^e.C[255&(d>>24^h[c++])]):l=!0;for(i=0;i<=8;i+=2)n|=parseInt(s.substring(13+i,15+i),16)<<4*i;if(n!==d)throw Error("WASM string decode failed crc32 validation");return h.subarray(0,c)}},M:{value(s){return s=e.U(s),new Promise((i=>{const r=String.raw`dynEncode0114db91da9bu*ttt$#U¤¤U¤¤3yzzss|yusvuyÚ&4<054<,5T44^T44<(6U~J(44< ~A544U~6J0444545 444J0444J,4U4UÒ7U454U4Z4U4U^/6545T4T44BU~64CU~O4U54U~5 U5T4B4Z!4U~5U5U5T4U~6U4ZTU5U5T44~4O4U2ZTU5T44Z!4B6T44U~64B6U~O44U~4O4U~54U~5 44~C4~54U~5 44~5454U4B6Ub!444~UO4U~5 U54U4ZTU#44U$464<4~B6^4<444~U~B4U~54U544~544~U5 µUä#UJUè#5TT4U0ZTTUX5U5T4T4Uà#~4OU4U $~C4~54U~5 T44$6U\!TTT4UaT4<6T4<64<Z!44~4N4<U~5 4UZ!4U±_TU#44UU6UÔ~B$544$6U\!4U6U¤#~B44Uä#~B$~64<6_TU#444U~B~6~54<Y!44<_!T4Y!4<64~444~AN44<U~6J4U5 44J4U[!U#44UO4U~54U~5 U54 7U6844J44J 4UJ4UJ04VK(44<J44<J$4U´~54U~5 4U¤~5!TTT4U$5"U5TTTTTTT4U$"4VK,U54<(6U~64<$6_!4< 64~6A54A544U~6#J(U54A4U[!44J(44#~A4U6UUU[!4464~64_!4<64~54<6T4<4]TU5 T4Y!44~44~AN4U~54U~54U5 44J(44J UÄA!U5U#UôJU"UÔJU#UÔ"JU#U´"JT4U´ZTU5T4UôZTU5T4UDZTU5T4U$[T44~UO4U~5 UÔUô4U~U´$.U5T4UP[T4U~4~UO4U~5 U#<U#<4U~U2$.UÄUN 44 ~UO4U~5 44!~UO4U~5 4U~4~UO4U~5 44J44J(U5 44U¤~J@44Uä~J<44UD~J844U~J44U$54U$5U54U$54U1^4U1^!4U~54U~5U54U~6U4U^/65T4T4U$54U~4BU~4O4U54U~5 UU'464U'_/54UU~5T4T4U~4BU~UO4U54U~5 U54Uä~4U¤~4U~U'$!44~5U5T44\T44U<~$6U\!4U#aT4U~4U~4O4U~5 U5U5U5TTT4U$"4YTU5 4U4~C5U5 U5U5444$4~64~\TU5 4U~4U~5T4Y!44O4U~54U~54U5 4CYTU5 4Uä~4U¤~4U~4$6TU54U\!44Bæ4Bä~[!4U~4UD~4U~4U~4$6TU54U\!44B4B~[!44U<~4U4~$5 4U"U#$544"Y!454U^!44<J44<(J454U~84­UN!#%'+/37?GOWgw·×÷Uä;U9$%& !"#`;e.u(e,r).then((t=>WebAssembly.instantiate(t,{}))).then((({exports:e})=>{const r=new Map(Object.entries(e)),n=r.get("puff"),h=r.get("memory").buffer,o=new t(h),a=new DataView(h);let l=r.get("__heap_base");const c=s.length,u=l;l+=4,a.setInt32(u,c,!0);const d=l;l+=c,o.set(s,d);const U=l;l+=4,a.setInt32(U,o.byteLength-l,!0),n(l,U,d,u),i(o.slice(l,l+a.getInt32(U,!0)))}))}))}}}),Object.defineProperty(this,"p",{enumerable:!0,get:()=>this.S}),this.F=(t,s,e)=>{let i=[],r=0;for(;r<s;)i.push(t.slice(r*e,r++*e+e));return i},this.v=(t,s,e=!0)=>{const i=this.S.B(s.BYTES_PER_ELEMENT*t);return e&&this._.add(i),{J:i,L:t,I:new s(this.S.P,i,t)}},this.free=()=>{this._.forEach((t=>{this.S.free(t)})),this._.clear()},this.Y=t=>{const s=[],e=new Uint8Array(this.S.P);for(let i=e[t];0!==i;i=e[++t])s.push(i);return String.fromCharCode.apply(null,s)},this.N=(t,s,e,i,r,n)=>{t.push({message:s,frameLength:e,frameNumber:i,inputBytes:r,outputSamples:n})},this.instantiate=(t,s)=>(s&&e.o(t,s),this.S=new t(e).instantiate(),this._=new Set,this.S.ready.then((()=>this)))}class i extends((()=>globalThis.Worker||s)()){constructor(t,s,i,r){e.t||new e;let n=e.t.get(i);if(!n){let t,s="text/javascript",h=`'use strict';(${""+((t,s,e)=>{let i,r,n=new Promise((t=>{r=t}));self.onmessage=({data:{id:h,command:o,data:a}})=>{let l,c=n,u={id:h};"init"===o?(Object.defineProperties(t,{W:{value:s},G:{value:e},D:{value:a.D},K:{value:!0}}),i=new t(a.options),r()):"free"===o?i.free():"ready"===o?c=c.then((()=>i.ready)):"reset"===o?c=c.then((()=>i.reset())):(Object.assign(u,i[o](Array.isArray(a)?a.map((t=>new Uint8Array(t))):new Uint8Array(a))),l=u.channelData?u.channelData.map((t=>t.buffer)):[]),c.then((()=>self.postMessage(u,l)))}})})(${i}, ${e}, ${r})`;try{t=void 0!==process.versions.node}catch{}n=t?`data:${s};base64,${Buffer.from(h).toString("base64")}`:URL.createObjectURL(new Blob([h],{type:s})),e.t.set(i,n)}super(n,{name:s}),this.R=Number.MIN_SAFE_INTEGER,this.V=new Map,this.onmessage=({data:t})=>{const{id:s,...e}=t;this.V.get(s)(e),this.V.delete(s)},new r(e).u().then((s=>{this.q("init",{D:s,options:t})}))}async q(t,s){return new Promise((e=>{this.postMessage({command:t,id:this.R,data:s}),this.V.set(this.R++,e)}))}get ready(){return this.q("ready")}async free(){await this.q("free").finally((()=>{this.terminate()}))}async reset(){await this.q("reset")}}const r=(t,s)=>{Object.defineProperty(t,"name",{value:s})},n=Symbol,h=(()=>{const t="left",s="center",e="right";return["","front ","side ","rear "].map((i=>[[t,e],[t,e,s],[t,s,e],[s,t,e],[s]].flatMap((t=>t.map((t=>i+t)).join(", ")))))})(),o="LFE",a="monophonic (mono)",l="stereo",c="surround",u=(t,...s)=>`${[a,l,"linear "+c,"quadraphonic","5.0 "+c,"5.1 "+c,"6.1 "+c,"7.1 "+c][t-1]} (${s.join(", ")})`,d=[a,u(2,h[0][0]),u(3,h[0][2]),u(4,h[1][0],h[3][0]),u(5,h[1][2],h[3][0]),u(6,h[1][2],h[3][0],o),u(7,h[1][2],h[2][0],h[3][4],o),u(8,h[1][2],h[2][0],h[3][0],o)],U=48e3,f=44100,p=32e3,y=24e3,m=22050,g=16e3,M=8e3,w="absoluteGranulePosition",b="bandwidth",T="bitDepth",$="bitrate",x=$+"Maximum",A=$+"Minimum",O=$+"Nominal",C="buffer",S=C+"Fullness",F="codec",v=F+"Frames",B="coupledStreamCount",_="crc",J=_+"16",k=_+"32",L="data",E="description",I="duration",P="emphasis",Y="hasOpusPadding",j="header",N="isContinuedPacket",W="isCopyrighted",G="isFirstPage",D="isHome",K="isLastPage",R="isOriginal",V="isPrivate",q="isVbr",z="layer",H="length",Q="mode",Z=Q+"Extension",X="mpeg",tt=X+"Version",st="numberAACFrames",et="outputGain",it="preSkip",rt="profile",nt=n(),ht="protection",ot="segments",at="subarray",lt="version",ct="vorbis",ut=ct+"Comments",dt=ct+"Setup",Ut="block",ft=Ut+"ingStrategy",pt=n(),yt=Ut+"Size",mt=Ut+"size0",gt=Ut+"size1",Mt=n(),wt="channel",bt=wt+"MappingFamily",Tt=wt+"MappingTable",$t=wt+"Mode",xt=n(),At=wt+"s",Ot="copyright",Ct=Ot+"Id",St=Ot+"IdStart",Ft="frame",vt=Ft+"Count",Bt=Ft+"Length",_t="Number",Jt=Ft+_t,kt=Ft+"Padding",Lt=Ft+"Size",Et="Rate",It="inputSample"+Et,Pt="page",Yt=Pt+"Checksum",jt=n(),Nt=Pt+"SegmentTable",Wt=Pt+"Sequence"+_t,Gt="sample",Dt=Gt+_t,Kt=Gt+Et,Rt=n(),Vt=Gt+"s",qt="stream",zt=qt+"Count",Ht=qt+"Info",Qt=qt+"Serial"+_t,Zt=qt+"StructureVersion",Xt="total",ts=Xt+"BytesOut",ss=Xt+"Duration",es=Xt+"Samples",is=n(),rs=n(),ns=n(),hs=n(),os=n(),as=n(),ls=n(),cs=n(),us=n(),ds=n(),Us=n(),fs=n(),ps=n(),ys=n(),ms=n(),gs=n(),Ms=n(),ws=n(),bs=Uint8Array,Ts=DataView,$s="reserved",xs="bad",As="free",Os="none",Cs="16bit CRC",Ss=(t,s,e)=>{for(let i=0;i<t[H];i++){let r=s(i);for(let t=8;t>0;t--)r=e(r);t[i]=r}return t},Fs=Ss(new bs(256),(t=>t),(t=>128&t?7^t<<1:t<<1)),vs=[Ss(new Uint16Array(256),(t=>t<<8),(t=>t<<1^(32768&t?32773:0)))],Bs=[Ss(new Uint32Array(256),(t=>t),(t=>t>>>1^3988292384*(1&t)))];for(let di=0;di<15;di++){vs.push(new Uint16Array(256)),Bs.push(new Uint32Array(256));for(let t=0;t<=255;t++)vs[di+1][t]=vs[0][vs[di][t]>>>8]^vs[di][t]<<8,Bs[di+1][t]=Bs[di][t]>>>8^Bs[0][255&Bs[di][t]]}const _s=t=>{const s=t[H],e=s-16;let i=0,r=0;for(;r<=e;)i=Bs[15][255&(t[r++]^i)]^Bs[14][255&(t[r++]^i>>>8)]^Bs[13][255&(t[r++]^i>>>16)]^Bs[12][t[r++]^i>>>24]^Bs[11][t[r++]]^Bs[10][t[r++]]^Bs[9][t[r++]]^Bs[8][t[r++]]^Bs[7][t[r++]]^Bs[6][t[r++]]^Bs[5][t[r++]]^Bs[4][t[r++]]^Bs[3][t[r++]]^Bs[2][t[r++]]^Bs[1][t[r++]]^Bs[0][t[r++]];for(;r!==s;)i=Bs[0][255&(i^t[r++])]^i>>>8;return-1^i},Js=(...t)=>{const s=new bs(t.reduce(((t,s)=>t+s[H]),0));return t.reduce(((t,e)=>(s.set(e,t),t+e[H])),0),s},ks=t=>String.fromCharCode(...t),Ls=[0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15],Es=t=>Ls[15&t]<<4|Ls[t>>4];class Is{constructor(t){this.H=t,this.Z=8*t[H]}set position(t){this.Z=t}get position(){return this.Z}read(t){const s=Math.floor(this.Z/8),e=this.Z%8;return this.Z-=t,(Es(this.H[s-1])<<8)+Es(this.H[s])>>7-e&255}}class Ps{constructor(t,s){this.X=t,this.tt=s,this[ms]()}[gs](){this.st=!0}[ms](){this.et=new Map,this.it=new WeakMap,this.rt=!1,this.nt=!1,this.ht=null,this.st=!1}[ys](t,s){if(this.tt){this.ht!==t&&(this.ht=t,this.nt=!0);const e=this.it.get(this.et.get(this.at));this.nt&&e&&this.tt({lt:t,...e},s),this.nt=!1}}[us](t){const s=this.et.get(t);return s&&this.ut(t),s}[ds](t,s,e){this.st&&(this.rt||(this.X({...s}),this.rt=!0),this.ut(t),this.et.set(t,s),this.it.set(s,e))}ut(t){this.tt&&t!==this.at&&(this.nt=!0,this.at=t)}}const Ys=new WeakMap,js=new WeakMap;class Ns{constructor(t,s){this.Ut=t,this.et=s}*[ls](){let t;for(;;){if(t=yield*this.yt[Us](this.Ut,this.et,0),t)return t;this.Ut[rs](1)}}*[cs](t){let s=yield*this[ls]();const e=js.get(s)[H];if(t||this.Ut.Mt||(yield*this.wt[us](this.Ut,this.et,e)))return this.et[gs](),this.Ut[rs](e),this.Ut[hs](s),s;this.Ut[os](`Missing ${Ft} at ${e} bytes from current position.`,`Dropping current ${Ft} and trying again.`),this.et[ms](),this.Ut[rs](1)}}class Ws{constructor(t,s){js.set(this,{[j]:t}),this[L]=s}}class Gs extends Ws{static*[Us](t,s,e,i,r){const n=yield*t[us](e,i,r);if(n){const t=Ys.get(n)[Bt],i=Ys.get(n)[Vt];return new s(n,(yield*e[is](t,r))[at](0,t),i)}return null}constructor(t,s,e){super(t,s),this[j]=t,this[Vt]=e,this[I]=e/t[Kt]*1e3,this[Jt]=null,this[ts]=null,this[es]=null,this[ss]=null,js.get(this)[H]=s[H]}}const Ds="unsynchronizationFlag",Ks="extendedHeaderFlag",Rs="experimentalFlag",Vs="footerPresent";class qs{static*Tt(t,s,e){const i={};let r=yield*t[is](3,e);if(73!==r[0]||68!==r[1]||51!==r[2])return null;if(r=yield*t[is](10,e),i[lt]=`id3v2.${r[3]}.${r[4]}`,15&r[5])return null;if(i[Ds]=!!(128&r[5]),i[Ks]=!!(64&r[5]),i[Rs]=!!(32&r[5]),i[Vs]=!!(16&r[5]),128&r[6]||128&r[7]||128&r[8]||128&r[9])return null;const n=r[6]<<21|r[7]<<14|r[8]<<7|r[9];return i[H]=10+n,new qs(i)}constructor(t){this[lt]=t[lt],this[Ds]=t[Ds],this[Ks]=t[Ks],this[Rs]=t[Rs],this[Vs]=t[Vs],this[H]=t[H]}}class zs{constructor(t){Ys.set(this,t),this[T]=t[T],this[$]=null,this[At]=t[At],this[$t]=t[$t],this[Kt]=t[Kt]}}const Hs={0:[As,As,As,As,As],16:[32,32,32,32,8],240:[xs,xs,xs,xs,xs]},Qs=(t,s,e)=>8*((t+e)%s+s)*(1<<(t+e)/s)-8*s*(s/8|0);for(let di=2;di<15;di++)Hs[di<<4]=[32*di,Qs(di,4,0),Qs(di,4,-1),Qs(di,8,4),Qs(di,8,0)];const Zs="bands ",Xs=" to 31",te={0:Zs+4+Xs,16:Zs+8+Xs,32:Zs+12+Xs,48:Zs+16+Xs},se="bitrateIndex",ee="v2",ie="v1",re="Intensity stereo ",ne=", MS stereo ",he="on",oe="off",ae={0:{[E]:$s},2:{[E]:"Layer III",[kt]:1,[Z]:{0:re+oe+ne+oe,16:re+he+ne+oe,32:re+oe+ne+he,48:re+he+ne+he},[ie]:{[se]:2,[Vt]:1152},[ee]:{[se]:4,[Vt]:576}},4:{[E]:"Layer II",[kt]:1,[Z]:te,[Vt]:1152,[ie]:{[se]:1},[ee]:{[se]:4}},6:{[E]:"Layer I",[kt]:4,[Z]:te,[Vt]:384,[ie]:{[se]:0},[ee]:{[se]:3}}},le="MPEG Version ",ce="ISO/IEC ",ue={0:{[E]:le+"2.5 (later extension of MPEG 2)",[z]:ee,[Kt]:{0:11025,4:12e3,8:M,12:$s}},8:{[E]:$s},16:{[E]:`${le}2 (${ce}13818-3)`,[z]:ee,[Kt]:{0:m,4:y,8:g,12:$s}},24:{[E]:`${le}1 (${ce}11172-3)`,[z]:ie,[Kt]:{0:f,4:U,8:p,12:$s}},length:H},de={0:Cs,1:Os},Ue={0:Os,1:"50/15 ms",2:$s,3:"CCIT J.17"},fe={0:{[At]:2,[E]:l},64:{[At]:2,[E]:"joint "+l},128:{[At]:2,[E]:"dual channel"},192:{[At]:1,[E]:a}};class pe extends zs{static*[us](t,s,e){const i={},r=yield*qs.Tt(t,s,e);r&&(yield*t[is](r[H],e),t[rs](r[H]));const n=yield*t[is](4,e),h=ks(n[at](0,4)),o=s[us](h);if(o)return new pe(o);if(255!==n[0]||n[1]<224)return null;const a=ue[24&n[1]];if(a[E]===$s)return null;const l=6&n[1];if(ae[l][E]===$s)return null;const c={...ae[l],...ae[l][a[z]]};if(i[tt]=a[E],i[z]=c[E],i[Vt]=c[Vt],i[ht]=de[1&n[1]],i[H]=4,i[$]=Hs[240&n[2]][c[se]],i[$]===xs)return null;if(i[Kt]=a[Kt][12&n[2]],i[Kt]===$s)return null;if(i[kt]=2&n[2]&&c[kt],i[V]=!!(1&n[2]),i[Bt]=Math.floor(125*i[$]*i[Vt]/i[Kt]+i[kt]),!i[Bt])return null;const u=192&n[3];if(i[$t]=fe[u][E],i[At]=fe[u][At],i[Z]=c[Z][48&n[3]],i[W]=!!(8&n[3]),i[R]=!!(4&n[3]),i[P]=Ue[3&n[3]],i[P]===$s)return null;i[T]=16;{const{length:t,frameLength:e,$t:r,...n}=i;s[ds](h,i,n)}return new pe(i)}constructor(t){super(t),this[$]=t[$],this[P]=t[P],this[kt]=t[kt],this[W]=t[W],this[R]=t[R],this[V]=t[V],this[z]=t[z],this[Z]=t[Z],this[tt]=t[tt],this[ht]=t[ht]}}class ye extends Gs{static*[Us](t,s,e){return yield*super[Us](pe,ye,t,s,e)}constructor(t,s,e){super(t,s,e)}}class me extends Ns{constructor(t,s,e){super(t,s),this.yt=ye,this.wt=pe,e(this[F])}get[F](){return X}*[fs](){return yield*this[cs]()}}const ge={0:"MPEG-4",8:"MPEG-2"},Me={0:"valid",2:xs,4:xs,6:xs},we={0:Cs,1:Os},be={0:"AAC Main",64:"AAC LC (Low Complexity)",128:"AAC SSR (Scalable Sample Rate)",192:"AAC LTP (Long Term Prediction)"},Te={0:96e3,4:88200,8:64e3,12:U,16:f,20:p,24:y,28:m,32:g,36:12e3,40:11025,44:M,48:7350,52:$s,56:$s,60:"frequency is written explicitly"},$e={0:{[At]:0,[E]:"Defined in AOT Specific Config"},64:{[At]:1,[E]:a},128:{[At]:2,[E]:u(2,h[0][0])},192:{[At]:3,[E]:u(3,h[1][3])},256:{[At]:4,[E]:u(4,h[1][3],h[3][4])},320:{[At]:5,[E]:u(5,h[1][3],h[3][0])},384:{[At]:6,[E]:u(6,h[1][3],h[3][0],o)},448:{[At]:8,[E]:u(8,h[1][3],h[2][0],h[3][0],o)}};class xe extends zs{static*[us](t,s,e){const i={},r=yield*t[is](7,e),n=ks([r[0],r[1],r[2],252&r[3]|3&r[6]]),h=s[us](n);if(h)Object.assign(i,h);else{if(255!==r[0]||r[1]<240)return null;if(i[tt]=ge[8&r[1]],i[z]=Me[6&r[1]],i[z]===xs)return null;const t=1&r[1];i[ht]=we[t],i[H]=t?7:9,i[nt]=192&r[2],i[Rt]=60&r[2];const e=2&r[2];if(i[rt]=be[i[nt]],i[Kt]=Te[i[Rt]],i[Kt]===$s)return null;i[V]=!!e,i[xt]=448&(r[2]<<8|r[3]),i[$t]=$e[i[xt]][E],i[At]=$e[i[xt]][At],i[R]=!!(32&r[3]),i[D]=!!(8&r[3]),i[Ct]=!!(8&r[3]),i[St]=!!(4&r[3]),i[T]=16,i[Vt]=1024,i[st]=3&r[6];{const{length:t,Ot:e,Ct:r,St:h,frameLength:o,$t:a,Ft:l,...c}=i;s[ds](n,i,c)}}if(i[Bt]=8191&(r[3]<<11|r[4]<<3|r[5]>>5),!i[Bt])return null;const o=2047&(r[5]<<6|r[6]>>2);return i[S]=2047===o?"VBR":o,new xe(i)}constructor(t){super(t),this[Ct]=t[Ct],this[St]=t[St],this[S]=t[S],this[D]=t[D],this[R]=t[R],this[V]=t[V],this[z]=t[z],this[H]=t[H],this[tt]=t[tt],this[st]=t[st],this[rt]=t[rt],this[ht]=t[ht]}get vt(){const t=Ys.get(this),s=t[nt]+64<<5|t[Rt]<<5|t[xt]>>3,e=new bs(2);return new Ts(e[C]).setUint16(0,s,!1),e}}class Ae extends Gs{static*[Us](t,s,e){return yield*super[Us](xe,Ae,t,s,e)}constructor(t,s,e){super(t,s,e)}}class Oe extends Ns{constructor(t,s,e){super(t,s),this.yt=Ae,this.wt=xe,e(this[F])}get[F](){return"aac"}*[fs](){return yield*this[cs]()}}class Ce extends Gs{static Bt(t){return(t[t[H]-2]<<8)+t[t[H]-1]}static[ws](t){const s=Ce.Bt(t),e=(t=>{const s=t[H],e=s-16;let i=0,r=0;for(;r<=e;)i^=t[r++]<<8|t[r++],i=vs[15][i>>8]^vs[14][255&i]^vs[13][t[r++]]^vs[12][t[r++]]^vs[11][t[r++]]^vs[10][t[r++]]^vs[9][t[r++]]^vs[8][t[r++]]^vs[7][t[r++]]^vs[6][t[r++]]^vs[5][t[r++]]^vs[4][t[r++]]^vs[3][t[r++]]^vs[2][t[r++]]^vs[1][t[r++]]^vs[0][t[r++]];for(;r!==s;)i=(255&i)<<8^vs[0][i>>8^t[r++]];return i})(t[at](0,-2));return s===e}constructor(t,s,e){s[Ht]=e,s[J]=Ce.Bt(t),super(s,t,Ys.get(s)[Vt])}}const Se="get from STREAMINFO metadata block",Fe={0:"Fixed",1:"Variable"},ve={0:$s,16:192};for(let di=2;di<16;di++)ve[di<<4]=di<6?576*2**(di-2):2**di;const Be={0:Se,1:88200,2:176400,3:192e3,4:M,5:g,6:m,7:y,8:p,9:f,10:U,11:96e3,15:xs},_e={0:{[At]:1,[E]:a},16:{[At]:2,[E]:u(2,h[0][0])},32:{[At]:3,[E]:u(3,h[0][1])},48:{[At]:4,[E]:u(4,h[1][0],h[3][0])},64:{[At]:5,[E]:u(5,h[1][1],h[3][0])},80:{[At]:6,[E]:u(6,h[1][1],o,h[3][0])},96:{[At]:7,[E]:u(7,h[1][1],o,h[3][4],h[2][0])},112:{[At]:8,[E]:u(8,h[1][1],o,h[3][0],h[2][0])},128:{[At]:2,[E]:l+" (left, diff)"},144:{[At]:2,[E]:l+" (diff, right)"},160:{[At]:2,[E]:l+" (avg, diff)"},176:$s,192:$s,208:$s,224:$s,240:$s},Je={0:Se,2:8,4:12,6:$s,8:16,10:20,12:24,14:$s};class ke extends zs{static Jt(t){if(t[0]>254)return null;if(t[0]<128)return{value:t[0],length:1};let s=1;for(let n=64;n&t[0];n>>=1)s++;let e=s-1,i=0,r=0;for(;e>0;r+=6,e--){if(128!=(192&t[e]))return null;i|=(63&t[e])<<r}return i|=(t[e]&127>>s)<<r,{value:i,length:s}}static[Ms](t,s){const e={*[is](){return t}};return ke[us](e,s,0).next().value}static*[us](t,s,e){let i=yield*t[is](6,e);if(255!==i[0]||248!==i[1]&&249!==i[1])return null;const r={},n=ks(i[at](0,4)),h=s[us](n);if(h)Object.assign(r,h);else{if(r[pt]=1&i[1],r[ft]=Fe[r[pt]],r[Mt]=240&i[2],r[Rt]=15&i[2],r[yt]=ve[r[Mt]],r[yt]===$s)return null;if(r[Kt]=Be[r[Rt]],r[Kt]===xs)return null;if(1&i[3])return null;const t=_e[240&i[3]];if(t===$s)return null;if(r[At]=t[At],r[$t]=t[E],r[T]=Je[14&i[3]],r[T]===$s)return null}r[H]=5,i=yield*t[is](r[H]+8,e);const o=ke.Jt(i[at](4));if(!o)return null;if(r[pt]?r[Dt]=o.value:r[Jt]=o.value,r[H]+=o[H],96===r[Mt]?(i[H]<r[H]&&(i=yield*t[is](r[H],e)),r[yt]=i[r[H]-1]+1,r[H]+=1):112===r[Mt]&&(i[H]<r[H]&&(i=yield*t[is](r[H],e)),r[yt]=(i[r[H]-1]<<8)+i[r[H]]+1,r[H]+=2),r[Vt]=r[yt],12===r[Rt]?(i[H]<r[H]&&(i=yield*t[is](r[H],e)),r[Kt]=1e3*i[r[H]-1],r[H]+=1):13===r[Rt]?(i[H]<r[H]&&(i=yield*t[is](r[H],e)),r[Kt]=(i[r[H]-1]<<8)+i[r[H]],r[H]+=2):14===r[Rt]&&(i[H]<r[H]&&(i=yield*t[is](r[H],e)),r[Kt]=10*((i[r[H]-1]<<8)+i[r[H]]),r[H]+=2),i[H]<r[H]&&(i=yield*t[is](r[H],e)),r[_]=i[r[H]-1],r[_]!==(t=>{let s=0;const e=t[H];for(let i=0;i!==e;i++)s=Fs[s^t[i]];return s})(i[at](0,r[H]-1)))return null;if(!h){const{Et:t,frameNumber:e,It:i,$t:h,St:o,Pt:a,Yt:l,length:c,...u}=r;s[ds](n,r,u)}return new ke(r)}constructor(t){super(t),this[J]=null,this[ft]=t[ft],this[yt]=t[yt],this[Jt]=t[Jt],this[Dt]=t[Dt],this[Ht]=null}}class Le extends Ns{constructor(t,s,e){super(t,s),this.yt=Ce,this.wt=ke,e(this[F])}get[F](){return"flac"}*jt(t){const s=yield*this.Ut[is](2,0),e=s[H]-2;for(;t<e;){if(255===s[t]){const e=s[t+1];if(248===e||249===e)break;255!==e&&t++}t++}return t}*[fs](){for(;;){const t=yield*ke[us](this.Ut,this.et,0);if(t){let s=Ys.get(t)[H]+2;for(;s<=524288;){if(this.Ut.Mt||(yield*ke[us](this.Ut,this.et,s))){let e=yield*this.Ut[is](s);if(this.Ut.Mt||(e=e[at](0,s)),Ce[ws](e)){const i=new Ce(e,t);return this.et[gs](),this.Ut[rs](s),this.Ut[hs](i),i}}s=yield*this.jt(s+1)}this.Ut[os](`Unable to sync FLAC frame after searching ${s} bytes.`),this.Ut[rs](s)}else this.Ut[rs](yield*this.jt(1))}}[ps](t){return 0===t[Wt]?(this.et[gs](),this.Wt=t[L][at](13)):1===t[Wt]||(t[v]=js.get(t)[ot].map((t=>{const s=ke[Ms](t,this.et);if(s)return new Ce(t,s,this.Wt);this.Ut[os]("Failed to parse Ogg FLAC frame","Skipping invalid FLAC frame")})).filter((t=>!!t))),t}}class Ee{static*[us](t,s,e){const i={};let r=yield*t[is](28,e);if(79!==r[0]||103!==r[1]||103!==r[2]||83!==r[3])return null;if(i[Zt]=r[4],248&r[5])return null;i[K]=!!(4&r[5]),i[G]=!!(2&r[5]),i[N]=!!(1&r[5]);const n=new Ts(bs.from(r[at](0,28))[C]);try{i[w]=n.getBigInt64(6,!0)}catch{}i[Qt]=n.getInt32(14,!0),i[Wt]=n.getInt32(18,!0),i[Yt]=n.getInt32(22,!0);const h=r[26];i[H]=h+27,r=yield*t[is](i[H],e),i[Bt]=0,i[Nt]=[],i[jt]=bs.from(r[at](27,i[H]));for(let o=0,a=0;o<h;o++){const t=i[jt][o];i[Bt]+=t,a+=t,255===t&&o!==h-1||(i[Nt].push(a),a=0)}return new Ee(i)}constructor(t){Ys.set(this,t),this[w]=t[w],this[N]=t[N],this[G]=t[G],this[K]=t[K],this[Nt]=t[Nt],this[Wt]=t[Wt],this[Yt]=t[Yt],this[Qt]=t[Qt]}}class Ie extends Ws{static*[Us](t,s,e){const i=yield*Ee[us](t,s,e);if(i){const s=Ys.get(i)[Bt],e=Ys.get(i)[H],r=e+s,n=(yield*t[is](r,0))[at](0,r),h=n[at](e,r);return new Ie(i,h,n)}return null}constructor(t,s,e){super(t,s),js.get(this)[H]=e[H],this[v]=[],this.Gt=e,this[w]=t[w],this[k]=t[Yt],this[I]=0,this[N]=t[N],this[G]=t[G],this[K]=t[K],this[Wt]=t[Wt],this[Vt]=0,this[Qt]=t[Qt]}}class Pe extends Gs{constructor(t,s){super(s,t,s[Lt]*s[vt]/1e3*s[Kt])}}const Ye={0:d.slice(0,2),1:d},je="SILK-only",Ne="CELT-only",We="Hybrid",Ge="narrowband",De="medium-band",Ke="wideband",Re="super-wideband",Ve="fullband",qe={0:{[Q]:je,[b]:Ge,[Lt]:10},8:{[Q]:je,[b]:Ge,[Lt]:20},16:{[Q]:je,[b]:Ge,[Lt]:40},24:{[Q]:je,[b]:Ge,[Lt]:60},32:{[Q]:je,[b]:De,[Lt]:10},40:{[Q]:je,[b]:De,[Lt]:20},48:{[Q]:je,[b]:De,[Lt]:40},56:{[Q]:je,[b]:De,[Lt]:60},64:{[Q]:je,[b]:Ke,[Lt]:10},72:{[Q]:je,[b]:Ke,[Lt]:20},80:{[Q]:je,[b]:Ke,[Lt]:40},88:{[Q]:je,[b]:Ke,[Lt]:60},96:{[Q]:We,[b]:Re,[Lt]:10},104:{[Q]:We,[b]:Re,[Lt]:20},112:{[Q]:We,[b]:Ve,[Lt]:10},120:{[Q]:We,[b]:Ve,[Lt]:20},128:{[Q]:Ne,[b]:Ge,[Lt]:2.5},136:{[Q]:Ne,[b]:Ge,[Lt]:5},144:{[Q]:Ne,[b]:Ge,[Lt]:10},152:{[Q]:Ne,[b]:Ge,[Lt]:20},160:{[Q]:Ne,[b]:Ke,[Lt]:2.5},168:{[Q]:Ne,[b]:Ke,[Lt]:5},176:{[Q]:Ne,[b]:Ke,[Lt]:10},184:{[Q]:Ne,[b]:Ke,[Lt]:20},192:{[Q]:Ne,[b]:Re,[Lt]:2.5},200:{[Q]:Ne,[b]:Re,[Lt]:5},208:{[Q]:Ne,[b]:Re,[Lt]:10},216:{[Q]:Ne,[b]:Re,[Lt]:20},224:{[Q]:Ne,[b]:Ve,[Lt]:2.5},232:{[Q]:Ne,[b]:Ve,[Lt]:5},240:{[Q]:Ne,[b]:Ve,[Lt]:10},248:{[Q]:Ne,[b]:Ve,[Lt]:20}};class ze extends zs{static[Ms](t,s,e){const i={};if(i[At]=t[9],i[bt]=t[18],i[H]=0!==i[bt]?21+i[At]:19,t[H]<i[H])throw Error("Out of data while inside an Ogg Page");const r=3&s[0],n=3===r?2:1,h=ks(t[at](0,i[H]))+ks(s[at](0,n)),o=e[us](h);if(o)return new ze(o);if("OpusHead"!==h.substr(0,8))return null;if(1!==t[8])return null;i[L]=bs.from(t[at](0,i[H]));const a=new Ts(i[L][C]);if(i[T]=16,i[it]=a.getUint16(10,!0),i[It]=a.getUint32(12,!0),i[Kt]=U,i[et]=a.getInt16(16,!0),i[bt]in Ye&&(i[$t]=Ye[i[bt]][i[At]-1],!i[$t]))return null;0!==i[bt]&&(i[zt]=t[19],i[B]=t[20],i[Tt]=[...t[at](21,i[At]+21)]);const l=qe[248&s[0]];switch(i[Q]=l[Q],i[b]=l[b],i[Lt]=l[Lt],r){case 0:i[vt]=1;break;case 1:case 2:i[vt]=2;break;case 3:i[q]=!!(128&s[1]),i[Y]=!!(64&s[1]),i[vt]=63&s[1];break;default:return null}{const{length:t,data:s,Dt:r,...n}=i;e[ds](h,i,n)}return new ze(i)}constructor(t){super(t),this[L]=t[L],this[b]=t[b],this[bt]=t[bt],this[Tt]=t[Tt],this[B]=t[B],this[vt]=t[vt],this[Lt]=t[Lt],this[Y]=t[Y],this[It]=t[It],this[q]=t[q],this[Q]=t[Q],this[et]=t[et],this[it]=t[it],this[zt]=t[zt]}}class He extends Ns{constructor(t,s,e){super(t,s),this.yt=Pe,this.wt=ze,e(this[F]),this.Kt=null}get[F](){return"opus"}[ps](t){return 0===t[Wt]?(this.et[gs](),this.Kt=t[L]):1===t[Wt]||(t[v]=js.get(t)[ot].map((t=>{const s=ze[Ms](this.Kt,t,this.et);if(s)return new Pe(t,s);this.Ut[as]("Failed to parse Ogg Opus Header","Not a valid Ogg Opus file")}))),t}}class Qe extends Gs{constructor(t,s,e){super(s,t,e)}}const Ze={};for(let di=0;di<8;di++)Ze[di+6]=2**(6+di);class Xe extends zs{static[Ms](t,s,e,i){if(t[H]<30)throw Error("Out of data while inside an Ogg Page");const r=ks(t[at](0,30)),n=s[us](r);if(n)return new Xe(n);const h={[H]:30};if("vorbis"!==r.substr(0,7))return null;h[L]=bs.from(t[at](0,30));const o=new Ts(h[L][C]);if(h[lt]=o.getUint32(7,!0),0!==h[lt])return null;if(h[At]=t[11],h[$t]=d[h[At]-1]||"application defined",h[Kt]=o.getUint32(12,!0),h[x]=o.getInt32(16,!0),h[O]=o.getInt32(20,!0),h[A]=o.getInt32(24,!0),h[gt]=Ze[(240&t[28])>>4],h[mt]=Ze[15&t[28]],h[mt]>h[gt])return null;if(1!==t[29])return null;h[T]=32,h[dt]=i,h[ut]=e;{const{length:t,data:e,version:i,Rt:n,Vt:o,...a}=h;s[ds](r,h,a)}return new Xe(h)}constructor(t){super(t),this[x]=t[x],this[A]=t[A],this[O]=t[O],this[mt]=t[mt],this[gt]=t[gt],this[L]=t[L],this[ut]=t[ut],this[dt]=t[dt]}}class ti extends Ns{constructor(t,s,e){super(t,s),this.yt=Qe,e(this[F]),this.Kt=null,this.qt=!1,this.zt={count:0},this.Ht=0,this.Qt=0}get[F](){return ct}[ps](t){t[v]=[];for(const s of js.get(t)[ot])if(1===s[0])this.et[gs](),this.Kt=t[L],this.qt=!1;else if(3===s[0])this.Zt=s;else if(5===s[0])this.Xt=s,this.zt=this.ts(s),this.qt=!0;else if(this.qt){const e=Xe[Ms](this.Kt,this.et,this.Zt,this.Xt);e?t[v].push(new Qe(s,e,this.ss(s,e))):this.Ut[as]("Failed to parse Ogg Vorbis Header","Not a valid Ogg Vorbis file")}return t}ss(t,s){const e=t[0]>>1,i=this.zt[e&this.zt.mask];i&&(this.Ht=e&this.zt.es?s[gt]:s[mt]),this.Qt=i?s[gt]:s[mt];const r=this.Ht+this.Qt>>2;return this.Ht=this.Qt,r}ts(t){const s=new Is(t),e="Failed to read "+ct+" stream",i=", failed to parse "+ct+" modes";let r,n={count:0};for(;1!=(1&s.read(1)););for(;n.count<64&&s.position>0;){const t=Es(s.read(8));if(t in n&&(1!==n.count||0!==t))throw this.Ut[as]("received duplicate mode mapping"+i),Error(e);let h=0;for(;0===s.read(8)&&h++<3;);if(4!==h){if(1+((126&Es(r))>>1)!==n.count)throw this.Ut[as]("mode count did not match actual modes"+i),Error(e);break}r=s.read(7),n[t]=1&r,s.position+=6,n.count++}return n.mask=(1<<Math.log2(n.count))-1,n.es=1+(1|n.mask),n}}class si{constructor(t,s,e){this.Ut=t,this.et=s,this.rs=e,this.ns=new bs,this.hs=null,this.os=null}get[F](){return this.hs||""}ls(t,s){this.hs!==t&&(this.et[ms](),this.cs=new s(this.Ut,this.et,this.rs),this.hs=t)}us({data:t}){const s=ks(t[at](0,8));switch(s){case"fishead\0":return!1;case"OpusHead":return this.ls("opus",He),!0;case/^\x7fFLAC/.test(s)&&s:return this.ls("flac",Le),!0;case/^\x01vorbis/.test(s)&&s:return this.ls(ct,ti),!0;default:return!1}}ds(t){t[Wt]!==this.Us+1&&this.Us>1&&t[Wt]>1&&this.Ut[os]("Unexpected gap in Ogg Page Sequence Number.",`Expected: ${this.Us+1}, Got: ${t[Wt]}`),this.Us=t[Wt]}fs(t){null===this.os&&(this.Us=t[Wt],this.os=this.us(t)),this.ds(t);const s=js.get(t),e=Ys.get(s[j]);let i=0;if(s[ot]=e[Nt].map((s=>t[L][at](i,i+=s))),this.ns[H]&&(s[ot][0]=Js(this.ns,s[ot][0]),this.ns=new bs),255===e[jt][e[jt][H]-1]&&(this.ns=Js(this.ns,s[ot].pop())),this.os){const s=this.cs[ps](t);return this.Ut[hs](s),s}return t}}class ei extends Ns{constructor(t,s,e){super(t,s),this.rs=e,this.yt=Ie,this.wt=Ee,this.ps=new Map,this.ys=null}get[F](){const t=this.ps.get(this.ys);return t?t.xt:""}*[fs](){const t=yield*this[cs](!0);this.ys=t[Qt];let s=this.ps.get(this.ys);return s||(s=new si(this.Ut,this.et,this.rs),this.ps.set(this.ys,s)),t[K]&&this.ps.delete(this.ys),s.fs(t)}}const ii=()=>{};class ri{constructor(t,{gs:s,Ms:e,ws:i,bs:r=!1,Ts:n=!0}={}){this.$s=t,this.rs=s||ii,this.X=e||ii,this.tt=i,this.xs=r,this.As=n?_s:ii,this.Os=this.Cs(),this.Os.next()}get[F](){return this.cs[F]}*flush(){this.Mt=!0;for(let t=this.Os.next();t.value;t=this.Os.next())yield t.value;this.Mt=!1,this.Os=this.Cs(),this.Os.next()}*Ss(t){for(let s=this.Os.next(t);s.value;s=this.Os.next())yield s.value}parseAll(t){return[...this.Ss(t),...this.flush()]}*Cs(){if(this.et=new Ps(this.X,this.tt),this.$s.match(/aac/))this.cs=new Oe(this,this.et,this.rs);else if(this.$s.match(/mpeg/))this.cs=new me(this,this.et,this.rs);else if(this.$s.match(/flac/))this.cs=new Le(this,this.et,this.rs);else{if(!this.$s.match(/ogg/))throw Error("Unsupported Codec "+mimeType);this.cs=new ei(this,this.et,this.rs)}for(this.Fs=0,this.vs=0,this.Bs=0,this._s=0,this.Js=0,this.ks=void 0,this.Ls=new Uint8Array(0);;){const t=yield*this.cs[fs]();t&&(yield t)}}*[is](t=0,s=0){let e;for(;this.Ls[H]<=t+s;){if(e=yield,this.Mt)return this.Ls[at](s);e&&(this.Bs+=e[H],this.Ls=Js(this.Ls,e))}return this.Ls[at](s)}[rs](t){this.vs+=t,this.Ls=this.Ls[at](t)}[ns](t){this.ks=t[j][Kt],t[j][$]=8*Math.round(t[L][H]/t[I]),t[Jt]=this.Fs++,t[ts]=this._s,t[es]=this.Js,t[ss]=this.Js/this.ks*1e3,t[k]=this.As(t[L]),this.et[ys](t[j][$],t[ss]),this._s+=t[L][H],this.Js+=t[Vt]}[hs](t){t[v]?(t[v].forEach((s=>{t[I]+=s[I],t[Vt]+=s[Vt],this[ns](s)})),t[es]=this.Js,t[ss]=this.Js/this.ks*1e3||0,t[ts]=this._s):this[ns](t)}Ys(t,s){if(this.xs){const e=[`${F}:         ${this[F]}`,"inputMimeType: "+this.$s,"readPosition:  "+this.vs,"totalBytesIn:  "+this.Bs,`${ts}: ${this._s}`],i=Math.max(...e.map((t=>t[H])));s.push("--stats--"+"-".repeat(i-9),...e,"-".repeat(i)),t("codec-parser",s.reduce(((t,s)=>t+"\n  "+s),""))}}[os](...t){this.Ys(console.warn,t)}[as](...t){this.Ys(console.error,t)}}const ni=L;function hi(t){function s(t){console.log(t)}function e(t){console.error(t)}function i(){}for(var r=new Uint8Array(123),n=25;n>=0;--n)r[48+n]=52+n,r[65+n]=n,r[97+n]=26+n;r[43]=62,r[47]=63,hi.p||Object.defineProperty(hi,"p",{get:()=>String.raw`dynEncode01d9fc6c0c93/qõ¤æo-®Çr_¾.¥ò>?= ´Z^¨E¨_lLKÓ½Lgº½ï4É
xø#~ÊQÊz~+âWÖÞ,É²^úÙ¹@¸Ëò°ÈÐúWØò­hð6þr§·Ç¼FîC"Óàr$¼Aé_µåªÝâWïä'xÜkÈÀ¼ÐäYËÖû½GÐ%¡ÜS»¢üj(µÛÚýÀyla%H;w »ë*û1¬XÑî2n¼pÒ¤ÉOÕã}Ñ.qßO9äÊëÅBN}dé¡sÐÅW´xÀªÐBoÂix>å©üÁ9úßQôÆ­ÞnH6Áøïv±véáÖ÷¿[Zö,üâJ
ìî>Æ´i³âG*>$Æ36=}Pzaò  ýÌz¨ÇKieZh&-
ä­Ôdfn@ã¥vßy§ËCñCq@aqs÷FÂ;¹ò@Ûa¦õ£Y»)B­þc=M]r,
#³òúÚy Y»«Ê[,¤=}ÙÜäo¤^¹Z¾Àæä"Y#n?õ¼ÇpKïQ¸^s®õÃ2|ûKb±kDæñB©Òl»]"xúð_nS8âack'Æ#lü9å´´¡°¡ûË÷¾*Ï¡dlHÃ¯9æ\l½³Y¬åy»C*°9ô\"LÂ·u<«)*
«#­°;c_Éûuc¶¾YÃípDEàEº"A15@'N:5mB¯2«2m²¸Zåx;ÒXE{6Éd×qîébÖ:ª< [®¯â8ªUQÑèyØ¸Ç9yÔÖÈÇN)íÏmÍÂü y@]?àgN#VÞ¶!Tú0o(%R¦y=M\¯å¶Ö:vv½ÎY?u6¬ø/ò¶?»Í',lÃ;T¡[6 ¯l~Ï¶eªïäF-çð*\Ö8¼u=}*¬®]Y&uÆ ø#4¤òìPXÍö:% 0­²W°\&0u^ö~°ÇNÛJ^HX"×Ñd6áØÜÅ¢þF¤Ò:Bc&A }ñKÖU¤[vÃ+ Â¢Ðc9­Äê2º1
c_N_Þ!äÞÔ»x]S®1ýiZì¹|ùìñµ
r}¤Æßµ»qr|8GP;øêgñ³¹¿C.ð¢j|æþ©¥§û{,G$sµÄåö _g|ÿq&Mõ_FòC|FKyÞðÀD°ãígRÎÅl²W±Ä&mÿKì3ubþ¼?'åÌ'qn¢þXhéü,Â¼ín|A4é=}Â=M_cÍuªöåÛ¼ïÐË~:6-} =}K# ]x\NÙ:yõÊYBÊ¡©Éñüur/ãbFê/&ôîs&tÅª}BµüF@hOsÏ÷¦PÎÁ6 ÈÆÓiBÔS¨hÐÁ¼«²EvbbÖ|k"ÒãÍñ
¹ôÊÜÆ5bKø4tg4BV<ÿ|_r|d|¿M¸;AmAÊS±Úc Í9ÆY)ã[vK°Øab§w*Ä¹ö,TÄø	ÃÏk²ëbSäç!0¯'÷?Qy³MA¤+8å$$¨>L;ô6u@
5ç$¸ÜîæS÷ZÎ*~»,;%ã{tv"%ã®ÅâRrAàÃÂ¼Åº#ÖoÊþ$ :Í#:^]m¦'BQóªæ¡O#Ï3Â·tê0©PC´«ÅãwJî¨Wò¨×÷¨#²¤KN=MºYÿÅ[IêK\7Îç Æànß0q>,Ê¦ eÄqcQ48¥CÔ~¥ Î·RSgÏ¼"LTgÏ"Æu@I	 üä&Ñº(ØÏDCO^¬p±	äþ¢JñåörÒ±t³»TbWöÁIrrrrrrgorrRq*k¬rÍMã_íÄÔÎ$|ó°1)enåÂ%¢aWºnQáç_¹¹gëØ$K>âåùáZ ¾kÒä4ÿÝÝÝÝ¿u«E±n»8«-±)] ¹ú¢©»ý½¤ÊHëß,¼w¨öù>ßÛåB÷ì¢/xéã¢	Sô2Qamn_Å«YåkY¼83'vF­6ÝñÌ)ü@}nju«!d¢ªÃÈÈöPU½µqÌR<¡Ï£Ò²£jõuÕI°×¼W;§6xJ	=M}ÿ¬§ãAä)1A¶h6µ|Á¤c.! ÞDnm=MBÂ3>¥<Õÿ^/­µÅóæ<w_vLÖc)b¤YÙeÙLçaÒóM¡ýÚQ¼¬Ò§ÆÄ\ _Ñ:¿i5ÖçMÆ¼ký=}¾³bfôÏ9¾
2míPÖÌ0*&{óÁ44¿=}n_g9ë òä'k=}2HÉªÜÔhJôª%|N ÅÄyÎ%@u·n6R,Ç}GD5ØoãE=M2K1ö¼0°ÄÆèÛ¾>3¥pÈâ¾+r­'%¨§6 vK½E²Zg¹ûå3Ã\b gànX]]ÃZ¼rB
Ôrþûg¦KÚgA«ª.K0Îá Ë5´@9~Ê5ÄÅ(Iâ:ÕàwáPo)¤bÆì÷s]¼³PÜhF6¶Ì-ð >7ÂÃQî¿dÚTG§½¬]p ¼0ÉÉ×ÂÔKZº"TS
´$üÃºÎXx°Êÿ÷4+RI>XxÆ±¤Ä£4WRÇØ÷5WüldIe¥ñ«$÷S@°­/p0Â¤H6VA)u=M.ØÏÎÑ|9')ÐélLÏejbÉùU	ìQ9Ô+IÃEÙ\Káuvü°<+ç+)Y:"ÐW@0ãN©ÌÔEäm7ôR]Dz8¸7wõVy¼ðxâÑ
P8ÑS½à¯ï3Aóz~3ÁsVplW¥¨6¶ÈUä6W&|)©×JÔ×Ï±¡aÁ abpo1ý5}ÔN_MXãgHUOp¿ß-üÈ¯¨ÆÈÆW¸ÍtÂrÐTÐÂ¢¯3¼y¶òí:¦öÍFýÛ$19Z^¶Íôõ¦h düÂ&É?9l¡ù ãguá=Mqê/[Ücñí4â[á;Ùä%[;m=}niúÊ(§P'¶Ã´Tw?0«³óÍG.vÓÀ­,'.ñ¥Õ§·Îçâ,ô××+9ÝåÛ²Xe.ÈûrîV³:Ý|{àlo·ÇîOÐcPÐÖrnOG;<@	|Ïy}©ßëu¥ý±Z ;*N
àY	mÖÜXvoF0b2[³Mcæÿ³ô%
+·9{f¨FåsEåÓô._±ñM<<©=}<Ù-Ü³±ñ=MÆ¡±ñS±lÄ9	*'ddýqKY3qÍ9Û+ð	ÀéJìm
-3}õZ\v.L,jê,j(©W>¿"ÎwzmG}hüu@]L?îÀÅ »uÎuÌo-áö[V«*[HóÕ×ìtã*NãÃ§×88~7l(oWH)2Æ+d2±áx?mcëj¹Ì!Ú¥¼÷²[bäó;ÅåÏÂhñ4üÅ]éÝÔVl	 Ï®Xz§®jÄTZ±/(1$Ô±1.ø.ÂDe= kyaGcÁGêH½ÛìªÐÍ®m¿ö>>(¥¥§êßP@×a&#£Á*©äÎE¨ÐBJ-Ë®jÅÉñQM(EÁª<#ÇiE^dÝu=}µ ù,øOf¢Ñ6ÂòºZõz?RT¸·F.F®êe·"vOÐ¼¨Êcmá'eë$Y"áòß0A+òÿ Vâ?Vºe¥¹õÄúZf0cPØhO¯½­VÍÿ4 f®
ÅÄÃQÌ­^#-0zkv²F½kvâË[ ªÞRh¶\R$ÑT¯òlpî= 
!Õl¾(êöÅÄ0sFÕHC>ÏÖßlW0.ïnÏÔI6Ô:Evaìí¨táÌzËd»?WqËÎïhû1}lçú$ n_¹TUqM¬u.iyÃÖ³PÊõ|­&ìoóÊ±2uWè|ïâA|xÒ\kpn«Ô¹ëa(µ^¢ó*ïãßöU£,Ræj)"B]p@çîs^=}µ7ÝøÌø !"C(ECy9ÌOÜ2mÖFùÿ6 LÍpÙ5ÔBi÷<±iñÜlù¨=M¿«ÆgTª	ü;\ ´£×d*ÊWVÌuðÑüe£t1Îüh9eRdd§yO,Ýx*ú@q;õëÌôjÃÛK£øqlÏÄôØÜj¶@<C±?d,{øªR­7>þeÌú¹¨9ú=}i¥!1¦b~[®Ï1tI¯Ð3 /U}ìpÝú×	H=}iç­)_¡¤#Æåy[>#«*{^!\é2an0ý­5j)}!H-3íâöíâ®ëcíây¤ K?~óÛqaûÚå IM3¢úòU À?Ó4ÀQ¿=}©0ïVbY¥!¡!\o<ïÖc¨Ñ;²/pBã¥£ñ_î9í= Ìb ©Ç>u/©£Æ){¡­â.hBÄ?LSA¯µ§òGbºOÞFIÉ¦7­µ¥¿?ñæ?¥ë<:Ð,«/8|yc>§e9;ù=}È3®Ì|¶{tþñÝh«1lk¤u£5´oÑà£B1¤éÚgUIÏ¥â&9/Õð­ä* ´ò^?	¤¿ÓV­_8·±½TsÚ´§eÔ*Ùú
¯ú®xU½{¸hL*ë}î_Øi¹ws6ÚÐôãS%8²ºR×zLî¼¶F=Mn¬Ê[q¿²]VN= =}2Ï=MØý¦Îâ ?½÷±DÂzä[ºÎ¶vr¬©Â«Ù©l­H,Ò£ç®EãÞùWntCÄg$é}5&%pO?Ðªb¹éËÞÌ;èuêz
:ñ©Ûìa¥%ah+´ÂØPØÌ¸ØÐXÍØëPÓÈØ·$Ö(×°ØÑ|ü"ÒÛ'wH+è´ÖÐspXu,Ø#{Óý&&  ÓKã= 2íÕKs[qò±<iÓåý_^­ËÏ3VR5!b ´k~ÞXâêvÎ×.n¶¨*¦uÄ¯Ð>çÚ£¯Ë½(£!Á£cø5.¾\ËõÛ,>Vã,</#Æ¿TLN8¼éy$ã°= 4.×¯Ã§úpUU.nhUDNn¸½éy$.£ 4.WKXz£õÛM7>Å»ecÓËlYdw3Ø {Ñ8©XßÊñÃLsyt>3l7Ã6+ÍB ­§ËYj(ÒB: <ËÔêñE5xÅ2!ñ)³Ù\¨,ÜÏrciRMáæ¼4¼ ,3'[[hd%ìqoÁ¿;ª¨#¬Ñ±ñÛ/­ ÖÞeCÏ¤[4*véfpZsQ94!9yC×6ÐÉò+7¾IÅdÞ°(ÅÅ¡;Á®¯~ðñnV±ÃnÁèbä¹aJVy0 >ÇÓ}JªCÁ/íò_û/Ï6_"­íÔºÓ§S¦t¾jÛ,p³FgfÉc¯y×P,ØÝ«Ñ=M?µ@Gfì'°P½ei"SGfkô°)î°Ðæ}m= s!_1ÃÁ¢údíw¥c[§ÄüniuLTg×7ùcj~= Ñ_¸ WùO ¡7iöj$Öwà"1gC/;´m¯Êu«=MDéûzPR­æ=}üOgxóæFGÅÓYDG|1"´?EÜß2, ö®ã;Pj×ks÷ó¨·÷6[¿Óñà-Ä<ù³ËG@¿°§&Ï#eé	= öà= p£|mµèìòßùÑü$ØX|ÃpõÄÐ)T¨êÀ!C]PÑÒK1øhÉ·KÙ²#°ª _ôuÿ^dÓp£uCÿ«:È0>Gaúqú
·>[]%"B	\Ê;0*@£TQ/>T¯L²þpxL¥úéäóß-ÄÒ\ýÜx­*ì@þT½õøm 5Råè¥ELè÷Yâ¾lÖM»ãpãøaìÉrKl!½Y¾ê,ðQÖáëÿèÎL.aKX¬á¶¼NÅ"Þª,*OíÇpOB:j Ñý> ò üºéÇeò)%Î)åAiÉ¥Ü¼ö
Û{¡Ï2*TEñà&ÏvFÏÏy§L¡J-d×cGõÚ?ëÑæk%·\JÄ=Ml!ÕéüÃ	éK/ªà;3Â>0S7Ã×LSía:Y*¸Ì×u¦Oï¨ò¼±5o)(­âS­íJFÿÔd@B¯ÞùTçÜ3?û73 _ ,¸°äÆÎÀÆê!ÝÛòùÙ§Ijt*^e°lN	nÌïNÆfFGÔ_¡§tÚRxû£¯®kuQñMÊÞ1KÙ'64Ï]¨<_]®÷a!	ö;;rf¤=}[E ÎàJN#,oCoY=M\ë:­7ò$«H4?Ôï=}v~Zn¦ô1wãR­+F·O"gßLÒrÊú!F§«5ùñÿi:ÉyJá/V§^Nb ,Ü&+ß-î)&:¾Jº~sS5ââzDÙck?ØÛg4aa6/¤qNJÂBÖïpæÍÈM	øËÊø»¼ UUl¼ÿm,»zÕ@GÜÕGbàÑ(üW×ì@Añ¼]»3bÄzÚÄa/ÃùõNé/ÚW»ÚÂômÀ¸ jøÊ@üï7öÊÍ&õÀ	hïè÷¨HÍ )0= u %Îèn½¯vÓgwÖ4íòªý'òjÑ5×Sn3íï./l
sFPÕçdã@©Öò¨¤Å
« |Lâ±ð Åü[ó«l4}À«æß:êß¥@$1^¯´ÞY^|);¥3ÛÆm_âVÎN³zýKÄzÔÖ«)ÃtæÌ]Ð¬
5iR LG]Í*!0rÉÔÚ÷b^+.Êz9Ç¨¡Ñ-~Há= wÆ7QV¼±ôN²²ç¢üH ¢²C%B0f&2~Bg½A÷c×Dm¥´}êÚÓî eÝ¢ÙicØAØa¬È @6Aüx=}ZÎXdÏ"q¬=}³ ].Øà;gÁüÃ!òmÒî<||¥ôSH}TÊör$÷ò·Ú®oõ)&¤åx"LUËKa(+ÏÊ>chtoÀ±2!¢óÑ{åÏê$jWì"EûËÿ+)=}©ÿí¢s¡íJì²¦$öU&ë7E^eøøÊfQ¯µ ëAÁêÀ!·äa°¬þÍñ&ì]ß[)áæ6[^WãË|uÖq$	þÍÒ=}[ñG¿Nq÷nÜ(5¡§RçJwÌ~¬K7¯f<¹qÿ,áüm)!&¤5_ðKõÁ	éÅnVúQ£&÷l%ñí$2
ìqOg  |QÍÜ÷Ö÷= xHéÚºùEÖ;·9=}E1)'8æ´)íÞcMy!¾ ñÔxÁyÑÄåãqÿ;>)!} \ûâ¤ohå1ÃUýàÜt¡aö@+ ÊÊßDüÇüåãù÷ßäa°ÒëSôe·½|à\ûÀÅ= ç÷íbEÄÓß¥RSu@õ!d{»ø$5"B»3»RìësnÑ}b ëxÊws$%ós(í¦]AV{A­OrG?M¬ÚF<1¡}r¥U$lÞºªwÿÆ1¸';U= ûA/©çÓ4ûÓ´CmL³=MpÑý(£¨¨ªÚÆ½¯ é/«.°Ë:ÿ!Ï«éT -ÙíVÊJÄ¼hÐÛK¢Æö¹¹j:¯CË	¬eë;Ë¥<?Ü?F(" dÐQô
èÇRIë"ôÉ¹YÌQ­©í?1Än6ñ,h4pD¹ ªã$mÝlí¤O¥¦V9VFÏÙ#á§¾7¹,	Bðõä¿Æ[ü@UÄÂäô:· 2@NaÊÚxXyIV^äJô]$»"ébÀvg1í®[ÒIàâ0)ÛÌY/é;÷uP]$­ÙwM]$m²Ù·s¬½o^¤Qµ5Úb¢{IrÜ]Äù#úüZ¡yáÀöºëû"¹6ID5G"M0­ú« ßUQïÏ!ÔÉ2wff¤ÑèSqéêô2Ërkÿ!w~¬«ËêÚÌ}èåK^ªµ¹õöÆß7Ü72!&UCis¸SÏaÄ´p_1X~ÑO²;Ð$:{¤ÑèkyÏ5ù®oVý¿ôôÑ~!0L2mËyåÀL¾´~æä»øØçvzÆéã=M;Ì*ô]f·yP­C/Z3ÎÊñ¬2d¯Æ;%I¶ÇS¸¶¾Èy/%MÝ{|(YA:QpAUrAM"pÁóKTøfMaEÅI Hæ:æ·\¢Î¨ÎÀ.ö¹-iùEßSF%,À²kzÊ= ¡èï°ªe6(+I=}]íý-ïBJjûZ4ÓÅ.kÛ d¢¬rëlBQpIÁ½bÁ}]gxag$AÐúPûKëswaë'^]ëQ1= åÇß\I]Ö©ìëOf"o÷d>võ\}Ie5"çccxq¢ ÄÁJ]cÎ%×¯°Xx«âÅÜ/Ó³¹~óOEÇ¸Ñ]mPÃ®ü;åÒdÌ*J[= \÷d °pÎÉí¦¤~IQ#òMdòCð¢&HRÛ«W¥¨áy½njz*KoëY£»¥Åx$8jj+2=}¥òKrPÚ>¿|r}O6×7Hþ¾èÉ!¾Lù'µ&pÈ×?|q¥þ¦WÞ­î»Ö~vî¸ôúÃø#ê^83Ýé@Rs¯Î½âO/¼ç
5ä¾òôõÙÁ ²W]åîùV!RÝÑRY¼ìåJ Y¸5¯ücWÏHf#±É¾,ÅUaÅÃpõÁÎ]¿ÛÏ[¿4E=M\ÞNyc²ø£éÇ$ü¢÷xå§E/o &âëa@}»ºðÁüªpA¥,mI("¿-Ê¦Gp	¯]êÔaaÃ+"@²ÜÃßñ¤î²ÊÐðèíô7G@áª5[!jÍ j2jwróÔëÊøþ5¯f¯Zé¦|FsUÌ¶r0)rhqjNwìPéïàÙé¦êõ:èãjRbïaíËã8wë ¯n= ¼ ! Z8þ·@¼È;-<ÓÓVx«*r@sþpðZ_Îâäàû
ñ&eÛ´àNÝw\å±Æe3û|0Y½¡êò	ÓeØ¾S+ å½¡sõ2 = ÀQÝg¤Õà0sê±'C%ÖÌý²ÀR1O#y7(ÓZìÉiÐ×~Y²¸e.%÷ÊÉÇlû@wõLõßÙñúº¾¸fZsaú~"âòÕ''y·j©Ðóæ¯ Ð}¾åé©ÝÇ<Å\ÀÌ¹Ì¹Ê2ÖõQ¶§Ã¤ï:C°þ¡½½n(úx]5¦A/Xé^+¸à?ciG)%q¡ó¿"Ú¡¿h;Ñl¹¨ÙX+5æ¥£äoøüx1â$oÑÊ¼©ß+Ftåò£µ#ºK^Ë¼³ªDÑ3Ë×Û}^0Á$a¼óÞVIaß^m6Âl=Mñ]Ïªë_ümàÚpä=}¾AZq iøþó25ìOºÝ¸gÔ¤>-Qö "Î_û	zæ°çCü°a®´kÑVjðA1bþÎÜØ©CI÷êN&Fîô­ì²äü® ý¹hªÑá¦	ÊÂoHJÅ=MD8	ãS¸;d"´¦ÓýÔfHJ0ÏhdH?Þ(î ÇÎ¨Å4²±S¸;¦¾4Eô¸;#ú0¬|1Éq¾éË¬O¥uë¸;«T5t 2É«Ð(©9*»)¥x¼û´ë½l!&ó×cã¼Þy/$ à³Åè¥23ÉtéÚ´2È8.²ÖÌõfILÑÜ£lËë{£à0.Ò9£Õ= ÙÆ-×¶3tÈ¦®îXfYºÓÉ5øG.Ò4Õ= Ù6ËÊ..·Ë®.WlY.Ò½xE.Ò®.w¾éy$.i«»ëPû½±nõMº
URhË£1Lñ°= ÷Í¹~·mJy«ÅÜ;"Ö30ÁµágÒ$W<öö¹D:yb<ü¼= rÜs w0»ó¦ÁPl¢cÊ
§gõ	>Ç@Û Bò?Ev_.Cd4wéTÏÜÜ<~ÂûjÕRwæ
r	þN8/úØ®Zð­;â[$jÈ§d1½~GjðVjpÀ72ËCá~¡DÌû0ïd5Æï»dË4d·ÃíúíÒ·¡ûHPd5Ì·rðRP¡TvûÝpûXù}HûUi^Û²Øw«®×ÉRðÆäÍ0ýa¦	Oî+lì¹5íç0l1O'¾»+B÷{çîÄ©í~èT$½¡Í·ÿt,ô¸·1o¹jfe/ÅÈ5­%ÎtkßÑ#ÿØ>e^Ý´¯8´_l¤t²Ößdr$ÃPÖ¬'I ~~ZB»p_±=MÜ{ãíÆ½ótÍ79x¢ß9ºÆVÉù.µ-7¥Ã°¶'D0mÃ¯ùVDi2ÞãB¡°²IR(P^ê«õ0&ÕUQ×Ujæ.wÓàÃ×Ûê0à{0µ:+û%í¾ÚH]®;$J8<Ç;2¸u0Ò¨@gY*FKüÖï·à©pª±Ë¤¦R·(©5þW©c,ÃÝä0¿3>
"N"BÇ°d'zv£)¨mÿ$mA³ÂTMJ[H¨ÄÔÒ´¯^Wp_tÓ©=Mì¿Zyùè<·¬	QÂ%a]¦ãÅJ½÷q±£¸ÌxLg§±æóléöûj/ö8T7 ¨g¯{ØfÕXJÿõ%ý«mmèk5ÔDoë(-&{R-òIÖÂðá¡Idð¼zJx}\cË6
Y´	àêÒ!«£ÖgÌ7Õ\ä¤¸¨Ëa6Ôv\×£léÔp0.·x@ÕönÐ¿Ø£¼éTÔ§ÆõÏXMG¿gr¨t1ÞÀG-]^Ô¼s¹òúp*Xmo2jjXòá\Ó=}_öãgÀXG=}%}E/DWÅo°¥.Lö¥èV\'*uô=M!%£{pÃ=}*}
Í$ÓÁòÃèÇãkÝ7®þñ-ÀÍú5ãÓ)¦l+Ú~86©Ñ&C5E#¾	i)Wá¬0éQ¼ÈP¢Û= ñ<,Ñ[_ÖÝëLc^d<°#L×Çy{ë]ßH=M©Û)¦©ÙÖZÿYó_ÏÜÍ?ÜY3_sÙÖ¬ßÚfòÙ~ÉYXç»zTJ¦·PÙâtu@8q¦fQþùi!¿Ô×$UÆuÇVÀ´¾§ÕÍY+ÏØ¿éc$A2N@Nó¬!!n ¥\p¬r´ú¶æmk	Ë²M©fUMijçÁù·xÜêÆ$¬MrBee	É_àÖîY&= rñ!úî­$ckàíml*]dÑÚáåm1»VP)mN¶Ú?z 7idÀ¤¯dhæÎ¡©Ö I¸çÈünñWV>oÔ£Tá&Ñ÷;#9×NÝ©Lä &¹FR=M¸ [S¦´o+D+"v©¾úþíÌ l2¼^[¡Å(ÙYn>= Îû Ûu{\JFYsÏ«:U©´5_÷)u@D50·+D»JÌ=}cVzÍÞÑE+ùeôP×À{Ñg<ÕÃð2Ó´íÆR«Ë<£ÆyÅêÕeôÑjàðG½
ÃÄ³øçöxÂh/0Wàf¨ÕYÙÆ»u&(qsòv8÷+ÏUîßºFÕ:°rq¸0âÜagC©¤ÜåÞ²ùCêå&)Ñ_;¬ôwvIÓfÀB¤n8©}ðM>=}Ú{ê³§À= r,YzºÉMÏF¢OÜ (*8·áGQw#ú}ýAìré¤y³,d¡dçV)Ðãö%íª«ÒÒA$ÍæÉsÃ9Ln
Ã1ßrp1Ê)õ!Á¯¦÷¡Ñõ«*fÖ= uÝ#ô¹8©éNé,[yC~Ì]¼ÃÆ?5o2Bx=M?¥ÐX+%$Þ8ù­÷Í&Lo·Ñ¥Rß¹UÕ6,mdH(³È¿Ðì lzë?qã4aI)áw/
§a1aÔ-C]</xâ½¦p¬2ÎÌýsþ¸H:ã¿Ï=}¤~ÕE¿ýsUw?
Õ'ÈUôQÔåGù,
@¡£ö11'wH·ÑçVM¶ÎÌèµ6¨.fqo¡ºI6§(ìØDë $ÆO7@= 	 !ßÂ×eãU=M+ÁeÐ:âBë®á,C;¿dÅïìù®Hº2göMu¡ÍÀMÀ^³=M6ò*ñh½U+ü¬OüÆ¡ÊO½=}ìND¸þ¤µé{Àê)za;Ý}A Ì£OJû)ê9}qÎ+c'© (-I:º5·âÖBCÐ#ü/³~Ññ4ÍZ¶ ¨ÊnÀÚ8R÷Gài|	1ù!!T>iNR_ÁGÊ÷(¶ic±È= Oµê'£ÍyÌôå®ë_û/}'¤C\y­7ÕèñyâæñÖJä§LÁqþSp°	#%©¥»Ý9j>£ÜbO*®áÔî.î£¤ì µÆQwotG÷K7$@¥ãöND×ÊÚÂÎ?öü±?{êÿ?{
rìàqA³%%%=}ÇÞ OX´¯mSûµ.¯1óªáÔ3þåèßgx2÷ &Ò$8K¼S¸²dM ×µÿø³:Y¥Á5ÌCìKOnbÎ.ïoÇ¿¢©01­Ò²#
[õ·ÛkÒÎÏå3ùÅlån»í¼W?k»áñüYsxv= ÈuEôPdê?.C=}óµÄ >  @ÖI¯7Áº¨Ê{  ÒüèóNÓ¯ùó½¶_ÉÀòKFNÔºG=}Ô¤ÕOÄõµriS5n"@ýxÁ#R;r;;¢=}Ãì!­d­æôw{É©8ös¼u¾ÓÒ.¯*¥ÜÃE5û(vT]/ªº©6·j[ßÐDrÆæôxä=}ÇÖd¨ÄEÆéT§ª3ÔÅBÖv@¤a¡	ÇÓÀBWÉþ(V\"AÉÇ©¹q^ÀÛ=MàùÈÒûÖ?k*PóxÀp8§ø§Ýj
ÅÎ¦mkî½!ëý =MÂ9fMD¾©ørõiU3GléÍ·qÞøkßßwÇh{O7|¹àrç!¸ó=}/\/«íGXî1øX£ 6Å¾RnBd¿6®PwN{ÁVp©ö_ój= À!Y¤)à$êíyYÆt¦/®wÄ4úP°ëKP§ÆkëS³ÈÔÉ_-| |coÚ¢¶ïk]ÕÛ{4CB= ¡1±-é7­kàÉÐd6Í¨'ÍþT©ÃéP0àØþ¢!°6îÙ~Û}ÛqãÖÊs8ÐÑ?ßa´3ÏT¦?ün>WL©®xÕ«xÃ(¢ Â(Ö~~¸ª<~CDÙ©ª¶^çÀò}3¦(SÛhzM¯¶í(	úd= .JíNJÚÈ ÑÓ×¡&5~ÿ¥@:qß¶ÆÏu;7	T±t£cnGÈåÃ~T_m_=}x%©imÅ|1´Åú{&U©¥~HÍÞÖÁñÚÖv¬½íb)¯h+¯hñÌÍoÓjÞ4F|øB@Gzø2øÎpÎü¦Ï*lS)l_ñf	ÂÜÓyEþÖµÅ+eZCytå3Àåü·ÚÂ4\¥)©f-F\<(ji¿Z#ªÊ×à{9êB<	ÂIÿTKýdæýqí 9S-Gó¿ô×NÌð£âg÷=M #x,ë"cm­¾Ñ&^ÕÛwar¼XÚíõ~íqÍÀÛiø\Ã´Ù®ô%Ð
ö4+<Ã-ó{Êè}LÚÇQÈ®~¸±tñÈÜ@2*äcJ= îB93'áÚá-:ø1,¾Áó{ôa¯õ99pNôÑúfæ?çL»YÞTÞÓÑnÎälÞ&ì;=MfrîC×Û°aDÝL)31ºÖ 9ñ3IÜstÒáõË#p©õ÷Òñ£¬¬Å¼t^ ËÑBß
Rref%Ò<&±ÎÖÄ"ò^ëçã¾õ«í=}=Mºiz©m^=M}i¼©a´õó,ApÄípì°Àáu»lm Ê¢¤<Ñí¾ÿlKäxBRà4¾@ÉJ¾vÑEpçx6W ïøKÝlvLÄ®2 ævvJÇÇ}ÈaÏ¨©P!¬öÍ&z´{+"8±Ûhª00¯ö~t«m¸	üÏmñãòÿæûý kx LìG³xMuôxý8$UÇÅî¿«¥·«&·2óîxþ0ìÀJHàÐ£f4!ËÙÔLð®ãPìºGµ]ìºÇ-þµN6¢\2Õ2ÄSGÅ2Â2M¥Á@ª­Áa@ª_@ªýÁg{N¤ûòÖê"ÅÞºw±läTã:¨±îÏEbÉêÆÇ=}?V_]CÛ?TF¤F¬Æq@³*¨@³ê¨fÜ¬ÿ¾Óû¬å½ox½ìxúTIêÒ£^Z^	IûåuO²Km²þ³ @ö.¿¢»¢¸É½(ÒÄwÕJùØAùX-çX+0abî;ìúð;äúOû«îB²Ãk¢}ø|Çøû7ÛgSï%ägQïEQï%ä¯ÜäÓG¬95g/¥hÍ4zj·§^Ú2ýD\¢3 µ,0|ÏÁhÓY×Á=MxÈ^'[SûÀ«P^Í¶}´ qiæÃeúÓ ÎÖ
ÊÝT[wy*gQ[_>û2xÐCfæ6¬äýÃ;¿"å¥ãêÈß¹$~²V?!ý@Åªö·OVeò»=}~vqn$¨Cù¡We<ÅÝ1Ê£;´ó%ÿÄ©e$¶¦´èÊ¥
µ´³~ZÍÒú//
p~]5ÿNr<ÊOqª§e°Õ¤Ã<ã´yö@ßÌGüRHªø(ä»ìU=MÈÄN=M¨úüâBÄt/{éPöÁçý»<G^µ]é®î*EaüùÛ{ì m«÷£¤h CÇãÍlãVgùÿî;ÍuñüÙ;]L_ Áôy¸½külõ2t.Ü®m*F[÷¼~0ç!©aý²þ= $aù3µ'6I&ÚM¦2@\é?SHV_sÖÈêd¸Ç lÄ¼;F=M¥sÍT;<x=}UVi3içcx4¿ÌÍfsÍHvNÒæòðyøß©6©= ÚMäÓÙVäÓùY·Þø8Ä[GÝ©0yÈà©0yÄÚÍ¾ÁèÛÁÂÁÙSäSY÷È[·ây= yÜÁ-ðMC¿úèOúè>'Oú ô¡ÖæýH9nÈHy 
Þ­ tÁõbÇKMbGLMbgÿªÿ¾Áb'B{Þ dÿsL=MH{â lÿCCtAMoÂÂÜtzõ¼dèÖM>WÂ+¡sPóxÄ÷CN£BOS1±Û=M¾6o÷^ëE)·ï)>NÍµ³UÜOÑÉ!Yz»KÀÏ ÉÚü´¶Òrhöv÷KmÒÚÙ@AmDqÊv8ÔU(sÍH( >F©= ÚMäÓùYwÂ[GÝ©²ÁSÙVäSY·Þì8Ä[Þ©0yÛÁ6©tÚÍ¾Á#Ù¶Þó(Oà©¼6©dÚÍIðÍÙvÃ[à©\öé7è­8ÚMØ+XÞ©Ê~×ãyTpÓYOpÓYpÓY5ðMC¿ú46¡¢¥ä·ÿ6¡GÜé°Ë=}³k}Aùä"ó!­¥«zz´JPÖ÷Å(o%qJWEìº:sG> ÝIÀ°1!ìWÍ¾¶Ñý¾RRèÒ,Ñ%£x@3·d¨/ÒU5ÒÑEpÐº4÷8µÉ\Ç	î7NÐÈÿ0¶ÊÀx^öÄÔòãiºÔõÞ_®ÁpÛBÃWsÛ#x{Y¥.PèÞM>6ã#8NP,ù­.PðÞOWÒNÁ8«_(i Ñµ4×Åûè\®	ô[¢gñ×òö[Ìx÷¨èøA]=}Ø½%bødd¥uYr	ý[0Gå¯V+õtÕî
Wë¯Ûlûñ¿¯úSxFµVj¾È¬
×a4=}ìôð9;Ýðµé%ÒÊQ
×$	×KÜïMåõ	[Q[YUY&½Ùüýº¼t÷kËû<í=MÜkG= kºEYÖ÷5ý@½qCá5cÓjSazhö>H|/ëüQPYnÚ3'äo6½E§mÓ<ÖùßÜ"0ß!ä'÷^|Æ)³1$	ü	 !µ=Muw´©Àè§ü¯°_æOuDÄ±p´e´v4S¾¶0²û·dµ-e°6­îfåæ,LäHÄàT,N¡@w0$7V;ù%Ó¶ý%ÅÙxþè4jwÅÊ´oÿÅÊ\þYOåy@yèÜÁEðÍ\ÙÓ?ðÍÙVäSY¯Þ¶áyO¸èyM°ÜÁ¤6©øÝ©¬6©TÚÍ=}ðÍGÙ·ÞìèPHà©Á­¥÷Å÷E£uÅ'iÔé¼â%OÑE¢Ìâ©í9¢Ìª6gÇªFgG* *°®õvªâ  &¹AªLg¿&=MºA« Fìfw@So²1WTÑS$·Æ"c}»
É()¥Hpzñ®¹°s0µeJ6m¤×Ü¢'Kìw¿p7Rû_$2sÆckÿù	Î3©C}Òï8á8³Ë¤Å£YÂÚà¬PÒRÙÄzOòè]s4â?¾#>à85yè¸ÿæÐäKVÖf¥î91QnÊ¥)¾®foUÉÒP÷É@<NLapÿÈ<Ñw;¦ZDXr¯rÃü.(NQi$C¤Z»Jì	¶¯d¾8¦þmD[üm3â'Y©T#Sø¹BÞ0x.¸úwª$9¾¸ì_$DÇ¥?ÄúìÕÁ=}Q£]s®-^ºQIºz¤¿^Q=}+:®í/¶´K8aá9²uãr«£ì.'7¡s;%I®Î=}çÏu(&d|¡\û¹ïh©âFEþêTãºÏ¨ooRp®Ã®ÁíI µü°xlòCI^1ä[ßf÷~:"bP»«= ÁÀC!üÇ^¥°Dkéu½½Fo-Vö°³?:Ç¹W5pà9æ	¹{¾¨J×Nw=}ñÓø6ìr<IR2wë0¨$¼*s¤7Qo= "+jÕµÝ5î,çß°£{ÃvyâÑÑô1Ãõ¦L%vn8®ÉÝÈ+kb	òZµyÄëáÍÉF¤ðT­äI±ÎÎüÂý}/ÞüÕOqUØãÿÈÞÅ]ÜûV.2fvG8©äÙÌ¶v¬×¯ßDrË¨X¤2Q~CE/= e*æ¯zVÎd,Ãh¬ éY¢ÝS9 ³+PÓL-	 rbá[$ÐË(ZZéVwÚ~WUJ¢xÔ¢B×>êÆ-Ïf@r·máÕYDÀóÃPT#
B=Mý ¢"òkF6é#zôAÉ]'
z6ãæ½mKAcÐñ¼GW²°Æ¸³MP7Ø 1»n_ÊµÄî"JÕ³ÖÿÝÛâj¸|·ùólT¥ÇA©ÛÌ0»¯ô4«Ø¤¾ãsqLuxÝoxÿf6ZsÑ¼IrhG¾ýd½ecÈ¼­Bÿm|+¾$Þ<þ¡.J Ú¥05p| Id<­= WâÇuTë.q}= ðéLãXMhÆyÕ}EZK¥s ÄÂSÒæí:iêäDE+B/YÇ
pÄCÀBãT{Ç ÅäýÎY4äÐïúÌæaEéñ5d±èVÀq!æ<ðýgIeàyÐÁù}lJà®ã±+Ëà¢¥B¨®>pÉÜÍzÆÒ#7îðÍuÚj&â¥¹Ë7Bª¥(A//%OÄ0ÇùE¤hµ^ »¤B
IÆÚN$ÕÑÈâvÿ5ø	J'bAÿ¬5sê@áþÛ¿e Qõ½P|2~j!&fî":ÌÑaU¯I ¥äñ¦ËË00 5XÁ÷Ìßß5À_ ?µ¬.+F$º}|ÈÊH= Ïè9kÀ£JÙc/©@9
JùB¼S­:5)æ «QsÛÊ°ÆGë°	r5¿òa·"*·1	Õm(syOgÈOK%pKÑj7Ã½q¾QlMK»Ø# ,¬k#tÉ²aHhºj!¨9>¿û_ "³ÿÑl¼{µâL,= <ïkx»&<f*Ãtóåôù²¯¾pí	40T¨¨UjØv,
ÄÍËrì*«Ñ7h!9$ÿqxtuøì¥+)~ÎÓ¨X>w«{ÓØV
¥ÈrÕÙÜDì-!wvX¼èX¼è| ©@dê¼þ\Wq^-·«Råôë¼LüèºrA§HS<Q^ÄQ­üwñ{o	-äÖ2À#üHR>2/È­Kæb¬Ì$Q]âþIÜh0BRë	¸Â0Î¨x¦õRöRÐpUd4J8òÇA×¨3Zºöø
>òw#©ª:@²I°òË©Éºµ2,y¨éÁþÁ¢µÍ= qIÖ=M¹I®ïU~¹xþAÎ#|=M0ï§èfðËg-òhuÿªÄPRå;] » )\k3>hl²Þ[Ûî÷íy­îÕ?ÒGçæt®zZm+§¸I­ÈJ(B<£ËrÌ´eØilÌÒoÐçY«°¢;mïx%	ý?vCÝe%½ó·ÌäÓ¤D¦m7|7KñWkí(© {È= ]NüÒª¾FsQ³vÝk3ÝdÚ¾A«ä6aêÖJS]ºà°¶Ë©Wéª´Ø·,[ù¤WÓû!m4ñûù;ðùd¾q¢À@öìÆÛ7/á"0ºÅôNë>=MYóp
|ÞSÑN<1Á·%Q¢snB~,×:] ot¼ï+@
m«0w2÷moD~±­¸¡þÁJÜÂ/z<=MÈLie¾«¥$q2ZÛ~(§¨Ì Gß÷\ÄZÏ)Û&{T\åÊîj=M/LvCCß3ßßI?kâm­çWLÛ<AhÏñ~ã$.÷ïJ³$kk×[ãÂ³ßeHoIúF¥KÍDWµ!b,8<Ø ØBjn#uîò¼ù'Òû'J×E¾]ìV¤±$;ñ«ëìâùU;"Û#Ë×·#)ö;o=}w6Ãª*d_eP¼Zâ),ðÆ¤:ÁV¼¿ÍÀû$ÓÊÒà{ÓõðDV'#Ö²;ÇC­»ÌAj¨oÑÉ êÊÒhüÉRíÑE¿U÷ÑEÜá¤j ^*(Ïéé(=}æåhé]fþòGÜþ_¶þ_´>QÅ-= ºàËy ÈlÎMjÜÊCçÍ[öâmÉ¤	B3·psiíH¶=MáU_Òi¾
rüî|\ è¥+¦0¯MCè©Ï9¦R>Cñ%§E+~ÌJ´÷N1èæÏ×29Øª@Ë?Zæd}î®z¶yad¡¶32Ò*'R®ecËMÒâzoM*$W­k®Y31j2j6jÌl£Dpâ3(FanøjK?,W Ê] ôôÚr÷áö?=Mïý¥FÞ´ûc®Ñ}.$*åÑ°:5nEýe.	j=MDð7£vlõ.LÄãa¾=Mî%¥fé¼k3n=MÄ²EÌ{ïORd(*ç:ÄÈj>îpN¥7oXÁëºIEðaXM:²ëÔFKJÿåHØ1w>\øÀ¦_DuÉo;O ZîeXû¦¬)@dAA{iÿQg-7bÐ¯ÕUæhá£= lBt}ñ1<cÃ9Ã3=Mç¶ÏÂñ= mç¶9{$ÁÀ!Ò^ä×î#Ý|;ü¤×{bvÿ%0rF7O½_Kõ	ÇÊH7rfâ9Â©c
$Îüè¹\§9DÓ½û2òýõ*ðiá²	:ø0ðð§¤ Z«÷ÖüKYÍñÌÿñ>6HH_rãÙ@ð^°ò¢wd¾ ö~öâ2ó
#Þ_ÛNÞ, Q°vÆ7Q¶Â¿áF/±;e9G(yÊ]IS¸ÕÀ¬£ÅôCt/«#®W; qÓVã=MþWé×7õ/ØXvL5:è£Ó EöÑlòõô]½À½ÿ¿.=}¿îmoýn~~ïîÚñ|ãýâ;éÑw©¼â0]LºØ®«ªKFcGç:+z?/Ôå¥ÿÑyþA5¢BH6We{ÕÜbwéGðâFx¶ìØ7¤äë¦¥Ì úk~¡¦É­øòúh¾ÎÒDò£¹Ü¿ºd[¦ !¦3Ã@"4ú+ø³\ª®%= |HF> äÙðÚÁ×&--Ù"Ù\æäÝ?%:Ùjæäjûàçâõôëî
ýüIPWRED;>!(-,36¹ÀÇÂÕÔËÎ±¸¯ª£¦ipwred[^z ¢§´µ®«ØÑÊÏ¼½ÆÃ~{haZ_lmvs ùøñêïÜÝæã0)27$%HA:?LMVSbg= Ynktu|}Ò×ÐÉ¾»ÄÅ¨¡¶³¬­BG@9NKTU*/81&#ò÷ðéÞÛäåúÿ=M'" +.54OJQXCF=}<	ûþßÚáèóöíìyojqxcf]\·²©°¥¤¿ºÁÝÜ9ùÙÙÛS´F´F´?F´F´F<´¶ ØVÞúëúß{KzÙËækz3zÜ³èßzãCÃzzÝcÃ'¹õ'ÄïÇÄ¹ì)XÉ/øÉåhá¤*D0àæt.	èã¼+	­üg|dÌ¬,b´V©T¯ôedÖa¨ÖªHÑ°ÚÕ¨Ãô ´ÌÂükÅKÈÇÇ7õGgGÆ?%Ç-¥§[§ÆEeq'ÅQåÈ!åaSYçÜã[ÙQÈF´F´¦³F´FvÕRßïàbé¸«ú~í_«/®yyî=}GÁFFÙÿ³íeIDBF©âÆ÷ó46ZBhÆ÷·´ ,Ìùù­×¬W´E6YOßðÆöë¦çÌFê?9&¬r5¥RwtM^¾Jw«äSoTÍùPLtWÀÎ©åª!ß¬(xÁ$W¿¨ SÿÄAü¨O³rF²= ÂA'¾Ýö¡ú³$t¿?*ï©c{~,f?«Íebòpûq^ÞkÙDÞõêðÙÀýøç:= ½ðJÚÉ(úãÚ»Û¹î!àµêðÙ°)&5Ù=MiÁ[/»Û9åÿ"ñÓbäY÷ÞR)!ÏzuÙZ=}»Ûù\¥ëëéÝàéáÙÙåa8!áúéëÛú]]!áúéëÛúúéëÛú]]!áúéëÛú]]!áFÅ\áJa@uùe=Mµú¤þ+!IgøUz¢SÁÉ¦Êcû(ùhäº¡G¥Ñd 4E¹§ï1
bL¥9f
üe:£ùñ	yÂi_gCb'D|v3¾]¿ÄzptÓÀg·»sÃ}\Ì·ykhÓ¿d£CÔ¼xW~_ÈcTºnk·e°÷{qãS½ZÛX[¹ÚÙ)ÝáÙ9¿¯Fô@´F´¥²F´F´sÛõa)[:ÑæWÝÜ9÷?5ÛX\	âXYL±Ý4æÅßH¹êOKIÝ':æ±_>éEYUÞPâßNyë÷T©ÞSºäA_PÉë=MJÉäÕ^ùôiÚ·úãè-9©ùa(5éªfA&­ïê÷
/ 5®'Ca[Sþò²0Xh½ÎuÓ8½Ë,­ j¡-f­=MCh³C=MG*¸*2æ²ÑcÃA=M{*>fNÍ*ÌÒc÷A3ÍS²©Åð|ÄsØªs8s¬Ï ÅHE7õ4­ÇB; $Æ©÷ ±O®«ÃUA
%¿8Ä{Îa²u¿
,j/AÕ)PcÁG»xÊP¶ø¶%XÄ¼t¶+ÕÀéPfTÄÍ¼5@~d NN#e§(µ@õMÉjÍtm îæSß}J««ùå"è\$«
BHi(óåT¢ø_eu&×ñk¢@RË­I=}ñ¢s	­tÂëçSt]@6È lùá¸SÆ]7&mªý7ì¸ÓÖ°8Â¨ëÄb6ÖkW
|ØlÑraZxX;3á:´M;áõt·Â¢Mðï%¦­¢Tx½%×+¨(lv¢N:"öbòè+D¼V£¯Ñ>U$Ò'¢ó¤Ê0# j+&ô\|ª¦Áîåe1ßL|_* ßN|Ø¹°Á¤á·
%àuãÜÚÙY -FgfBLÅ1t<F³õäú]éáú]éáú]éáú]éáú]éáú]éQÐøh~Ø X$×¥íÁÊ°8s²©tÓÊ0>'jUÑÎÁt)ýð7ªhx¡jç5= ú;ÔâÇ¤ÜÔ&ô~³bà2{ÿöjeèÁZ%Å÷È©ÓEêt2ÙÞ¢~ø½«+¿K/gm5kÏ;E#
æ}qêÈ+ câdäJõ(Ñþ Ñ0¹Õd(LôG¡¸¹µ"¡\äQã	ïç6Ñá )ì¯ÙÛ*ñÞVÛáãO}õõ[BjRiæ{=}ï¢\5\kÐW¬ÔÒ"H¹FÖeXÐ7ªR±8Ñ,hò$t¹6Ñ^¬Ï÷»mÖæ5('·(ÀgvilL0G¶Ò ¿6Ác§!<­b­aS¯ã30VBF|æ®mÏ/ôC.Wªxh:á¿Ín7= øQ­DI6]üHÛì2Eö²À/¯csF¥.T|;=Mª¨!{Ú³óò¼gAµéïíÖpMºµXõ.úIFù,éã°ßº«±=}Ä±j¿¡19LFENÅ³5ôá^D|n~°=M-Ä³e^³5ôtEö²OF)¬¸¨ÈÔÈTxÀ×¨ÔÎÒÕP8zØraÛÚ:Ü\êt[BïK>(±oº·QH¢÷GFP	ób#²Â³ÂfKÅËÐTþÇëöè½à¿õ»ß½øm÷=Mç9Ó®Ç0Ç°Ïlø©Ð@Ôpöù¶/l.ÅnÎúÔMÅ®½ý}= Ã´((ª0M³kørLsônXScò*T#R#W+uö7OkQ|ÔÂÑæ\6ÿü>öO¦â®	S1¬â8paÜ;L¯qÙBàIìÂ¢L BRiM~¦@L# Éúk|±©<<z¡¹müü·g×Áy{¿²ÕÅuµuÕBvJçÏsËsOw7pv4/(}M°sC_2½gó#sµ­¥¯¤¤crY¬îK2nZTq£:ñ'|z}nn#@k~îx66å'?}­CõpÕ¬ªÂbpY]¥)zú¹¤Òÿ= öè î©#£ ú$*Qå+]fgDôõfe&OîT §Ò z¼ë¨b§t ÊlK§LìÌ¤~¾b¥½³ä£ä³¢ËãÖíO#2Þ
z­-w9lþkbö>së®QSU,â~ANÃuã^X1]Ü¯Ap%9µ±àÂÄï±ÍãõÄÔÜîe29"I<øãçãã=}MuOÝ=M«	Äe ë¥/Æ|JúH3zvå&ËärMãU]:5Bv&pâåñ@ú¶Û7ZÖO;Ú
¸x8ù/<Ï-)ö5-}ðB)sæ®pÛ¤¤É~/ö= £)+@5^O_0R0)¤Î¤²îcÎÉUî¼åÜbòùt¶tº·æ­ÖO\;¦f¸§«ÆÂ9I\·¦]¥WsÂ¥ú?xüYöøÝèÝr.ïv¶âÆÊÈPhÜ  É¼¯µ"²"ËejEGô%Sh+ Í ±|c+yý5[p3¤ã2Þ2GMùmt[ö·û18¥ïµoPdÄTö1ø=}-.M~ßÏ0|§´vÉöÕÎïP,Ol>gµI¸YTí|@1h»ÚJ¸UxXùÏ<Ï/©ø µ.¶~ÈBtzïXä³ÅU%
ºødyáOÝøh-hÁ= ³O¦¸_TY0º0QhÎÞÐ+ÏkU:UgL\xTR}è©XBoôïBO{AÆ1¢-80ç¬¨PùIiø£Þ!¥ßÄçôgºaEO ¥Lcö§fãvïî[Ká+ïù<NÀå@Ê
Ý4r"hÐ59IìÀÚ~#7âsó-ñVC$dsÂKÌUÎZWÁ4É&Á¾Pá{D	=M»ó»6´ÐgøÁÐ7ÏFÇv)ì-S0Wè7B*%@Cµ 0*6èq¾Xyn8Úpk]°B³*Ü_r³(¡­?°<?|üé½a×ÞY0% gì¸±7×|ÏM8J8_û
ð³mùÔNÖæÜÉÝ:dI«ï(íd´öÃæõp£½JÉâ¦áÍýO=M«ëkm¦î¤õÊæãå¾hÛ~«Ûª%K¬ý$ÛÂy0,Åôðñ¦ðb+©>~ãtDq\8þ5=} ë&T?pdzFÂÒûÑgd·Gr«Ì¢Ä­æ°Û_ÊÜ ÍúÑÍtËü½@v·ëØ^ÑªÏ¼ÜÓ ¨;o¾Uzþ{¨XynxûXÂòeÑxø(õø¬T¯ÚgäÚS}½´º0s%ÍþÏ=}Eüx,¨54riüi§ÌÙéæÏ\Ó=}ýád:;tsq¢ÅAZ8 ñ¡æ­ïSl¢L´Ñ~Yç5ç_ðûBó4Y¸úGk÷ÃVhB?4ÔUèÉÛå¨¹ !ô³Z$ZKñ{¹}ó µÑâ»ýRmûÂE? TiËÒ2Khî½/3óOøC´´2ïJ¿5Uk$VJÊp¬8 ]<»xÿÖz¿ïØ¿ÈÍøfÞ¸/×­Ø«ÏDÀÔê$;ÍÊøþW@
¿Íh¯¿óäÕº?Æd§}òLã+ %B÷¬ÿÈeaÁö¬7kýÕQPÊ¹«M~>sFw<ª"A1U!ýÃþöÈ|e¬e©æqob)ÂãÒ¾ûf/pCqH3HEôöt6?ºÜGæëmËËÀ£= sO6©ÉM´K¤GÇS3]YáöuöJ±52wÛ)zë*^!Ç)/CCMN_3lËÅ²]=}Î«kD=}±(Àö¥ûóPÅH¸°ÎVO,7ºP.Ó3WGØÄ¡Ç±§]XlX(æÒLÆòx=}¢´-ÑB®f8q³ÈÓùKJÅ£]èl¸$VTb?Ætòjj*Üë¢+= òï¥!§ws).zJ;¤±OÄ-ÙÚY1Ix¹!=My!-(^S=MÙµíUgù3QÐyÒ[áz÷Ñ= [ÜÄ-¹N¨4nÈáTYëªà)îðyk±A¹ØùØºêÞ:"-hIÙNñoaÑJÁØÙ`});var h,o,a,l,c,u,d,U,f=new TextDecoder("utf8"),p={Ws:{},Gs:[null,[],[]],Ds(t,i){var r=p.Gs[t];0===i||10===i?((1===t?s:e)(((t,s,e)=>{for(var i=0;t[i]&&!(i>=NaN);)++i;return f.decode(t.subarray?t.subarray(0,i):new Uint8Array(t.slice(0,i)))})(r)),r.length=0):r.push(i)},Ks:void 0,get:()=>(p.Ks+=4,h[p.Ks-4>>2]),Rs(t){var s=((t,s)=>{if(!t)return"";for(var e=t+void 0,i=t;!(i>=e)&&o[i];)++i;return f.decode(o.subarray(t,i))})(t);return s},Vs:(t,s)=>t},y={d(t,s,e){o.copyWithin(t,s,s+e)},c(t){o.length,(t=>{throw"OOM"})()},b:t=>0,a(t,s,e,i){var r=p.qs(t),n=p.zs(r,s,e);return h[i>>2]=n,0},e(t,s,e,i,r){}},m={a:y};this.o=s=>{t.o(hi,s)},this.u=()=>t.u(hi),this.instantiate=()=>(this.u().then((t=>WebAssembly.instantiate(t,m))).then((t=>{var s,e=t.exports;l=e.h,c=e.i,u=e.j,d=e.k,U=e.l,e.m,s=e.f.buffer,a=s,h=new Int32Array(s),o=new Uint8Array(s),(t=>{t.g()})(e),i()})),this.ready=new Promise((t=>{i=t})).then((()=>{this.P=a,this.B=c,this.free=l,this.Hs=u,this.Qs=d,this.Zs=U})),this)}function oi(){return this.Xs=()=>(new this.te).instantiate(this.se,this.ee).then((t=>{this.ie=t,this.re=0,this.ne=0,this.Fs=0,this.he=this.ie.v(1,Uint32Array),this.ks=this.ie.v(1,Uint32Array),this.oe=this.ie.v(1,Uint32Array),this.ae=this.ie.v(1,Uint32Array),this.le=this.ie.v(1,Uint32Array),this.ce=this.ie.v(1,Uint32Array),this.ue=this.ie.v(1,Uint32Array),this.de=this.ie.v(1,Uint32Array),this.Ue=this.ie.p.Hs(this.he.J,this.ks.J,this.oe.J,this.ae.J,this.le.J,this.ce.J,this.ue.J,this.de.J)})),Object.defineProperty(this,"ready",{enumerable:!0,get:()=>this.fe}),this.reset=()=>(this.free(),this.Xs()),this.free=()=>{this.ie.p.Qs(this.Ue),this.ie.free()},this.pe=t=>{if(!(t instanceof Uint8Array))throw Error("Data to decode must be Uint8Array. Instead got "+typeof t);const s=this.ie.v(t.length,Uint8Array,!1);s.I.set(t),this.ie.p.Zs(this.Ue,s.J,s.L);let e,i=[];this.ue.I[0]&&i.push("Error: "+this.ie.Y(this.ue.I[0])),this.de.I[0]&&i.push("State: "+this.ie.Y(this.de.I[0])),i.length&&(e=i.join("; "),console.error("@wasm-audio-decoders/flac: \n\t"+i.join("\n\t")));const r=new Float32Array(this.ie.p.P,this.le.I[0],this.ce.I[0]),n={error:e,outputBuffer:this.ie.F(r,this.he.I[0],this.ae.I[0]),samplesDecoded:this.ae.I[0]};return this.ie.p.free(this.le.I[0]),this.ce.I[0]=0,this.ae.I[0]=0,n},this.decodeFrames=t=>{let s=[],e=[],i=0;for(let r=0;r<t.length;r++){let n=0;const h=t[r];for(;n<h.length;){const t=h.subarray(n,n+this.ye);n+=t.length;const r=this.pe(t);s.push(r.outputBuffer),i+=r.samplesDecoded,r.error&&this.ie.N(e,r.error,h.length,this.Fs,this.re,this.ne),this.re+=h.length,this.ne+=r.samplesDecoded}this.Fs++}return this.te.O(e,s,this.he.I[0],i,this.ks.I[0],this.oe.I[0])},this.me=oi.K,this.te=oi.W||e,this.se=oi.G||hi,this.ee=oi.D,this.ye=524280,this.fe=this.Xs(),this}const ai=Symbol();class li{constructor(){this.rs=t=>{if("flac"!==t)throw Error("@wasm-audio-decoders/flac does not support this codec "+t)},new e,this.Xs(),this[ai](oi)}Xs(){this.Ut=new ri("audio/flac",{gs:this.rs,Ts:!1})}[ai](t){if(this.Ue){const t=this.Ue;t.ready.then((()=>t.free()))}this.Ue=new t,this.fe=this.Ue.ready}get ready(){return this.fe}async reset(){return this.Xs(),this.Ue.reset()}free(){this.Ue.free()}async decode(t){return this.Ue.decodeFrames([...this.Ut.Ss(t)].map((t=>t[ni])))}async flush(){const t=this.Ue.decodeFrames([...this.Ut.flush()].map((t=>t[ni])));return await this.reset(),t}async decodeFile(t){const s=this.Ue.decodeFrames([...this.Ut.parseAll(t)].map((t=>t[ni])));return await this.reset(),s}async decodeFrames(t){return this.Ue.decodeFrames(t)}}class ci extends i{constructor(t){super(t,"flac-decoder",oi,hi)}async decodeFrames(t){return this.q("decodeFrames",t)}}class ui extends li{constructor(){super(),super[ai](ci)}async free(){super.free()}terminate(){this.Ue.terminate()}}r(li,"FLACDecoder"),r(ui,"FLACDecoderWebWorker"),t.FLACDecoder=li,t.FLACDecoderWebWorker=ui},"object"==typeof exports&&"undefined"!=typeof module?s(exports,require("@eshaz/web-worker")):"function"==typeof define&&define.amd?define(["exports","@eshaz/web-worker"],s):s((t="undefined"!=typeof globalThis?globalThis:t||self)["flac-decoder"]={},t.Worker);
//# sourceMappingURL=flac-decoder.min.js.map